/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.util.ChangeStorage;
import com.ldtteam.structurize.util.TickedWorldOperation;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class RemoveEntityMessage
implements IMessage {
    private final BlockPos from;
    private final BlockPos to;
    private final String entityName;

    public RemoveEntityMessage(FriendlyByteBuf buf) {
        this.from = buf.m_130135_();
        this.to = buf.m_130135_();
        this.entityName = buf.m_130136_(Short.MAX_VALUE);
    }

    public RemoveEntityMessage(BlockPos pos1, BlockPos pos2, String entityName) {
        this.from = pos1;
        this.to = pos2;
        this.entityName = entityName;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.from);
        buf.m_130064_(this.to);
        buf.m_130070_(this.entityName);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (!ctxIn.getSender().m_7500_()) {
            return;
        }
        Level world = ctxIn.getSender().m_9236_();
        ChangeStorage storage = new ChangeStorage(TickedWorldOperation.OperationType.REMOVE_ENTITY.toString(), ctxIn.getSender().m_20148_());
        for (int x = Math.min(this.from.m_123341_(), this.to.m_123341_()); x <= Math.max(this.from.m_123341_(), this.to.m_123341_()); ++x) {
            for (int y = Math.min(this.from.m_123342_(), this.to.m_123342_()); y <= Math.max(this.from.m_123342_(), this.to.m_123342_()); ++y) {
                for (int z = Math.min(this.from.m_123343_(), this.to.m_123343_()); z <= Math.max(this.from.m_123343_(), this.to.m_123343_()); ++z) {
                    BlockPos here = new BlockPos(x, y, z);
                    List list = world.m_45976_(Entity.class, new AABB(here));
                    storage.addEntities(list);
                    for (Entity entity : list) {
                        if (!entity.m_7755_().getString().equals(this.entityName)) continue;
                        entity.m_142687_(Entity.RemovalReason.DISCARDED);
                    }
                }
            }
        }
        Manager.addToUndoRedoCache(storage);
    }
}

