/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractItemWithPosSelector
extends Item {
    private static final String NBT_START_POS = "structurize:start_pos";
    private static final String NBT_END_POS = "structurize:end_pos";
    private static final String START_POS_TKEY = "item.possetter.firstpos";
    private static final String END_POS_TKEY = "item.possetter.secondpos";
    private static final String MISSING_POS_TKEY = "item.possetter.missingpos";

    public AbstractItemWithPosSelector(Item.Properties properties) {
        super(properties);
    }

    public abstract InteractionResult onAirRightClick(BlockPos var1, BlockPos var2, Level var3, Player var4, ItemStack var5);

    public abstract AbstractItemWithPosSelector getRegisteredItemInstance();

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        CompoundTag compound = itemstack.m_41784_();
        if (!compound.m_128441_(NBT_START_POS)) {
            if (worldIn.m_5776_()) {
                playerIn.m_5661_((Component)Component.m_237115_((String)"item.possetter.missingpos1"), false);
            }
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (!compound.m_128441_(NBT_END_POS)) {
            if (worldIn.m_5776_()) {
                playerIn.m_5661_((Component)Component.m_237115_((String)"item.possetter.missingpos2"), false);
            }
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        return new InteractionResultHolder(this.onAirRightClick(NbtUtils.m_129239_((CompoundTag)compound.m_128469_(NBT_START_POS)), NbtUtils.m_129239_((CompoundTag)compound.m_128469_(NBT_END_POS)), worldIn, playerIn, itemstack), (Object)itemstack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        if (context.m_43725_().m_5776_()) {
            context.m_43723_().m_5661_((Component)Component.m_237110_((String)END_POS_TKEY, (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), false);
        }
        context.m_43722_().m_41784_().m_128365_(NBT_END_POS, (Tag)NbtUtils.m_129224_((BlockPos)pos));
        return InteractionResult.SUCCESS;
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        ItemStack itemstack = player.m_21205_();
        if (!itemstack.m_41720_().equals((Object)this.getRegisteredItemInstance())) {
            itemstack = player.m_21206_();
        }
        itemstack.m_41784_().m_128365_(NBT_START_POS, (Tag)NbtUtils.m_129224_((BlockPos)pos));
        if (player.m_20193_().m_5776_()) {
            player.m_5661_((Component)Component.m_237110_((String)START_POS_TKEY, (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), false);
        }
        return false;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return Float.MAX_VALUE;
    }

    public static void setBounds(@NotNull ItemStack tool, @NotNull BlockPos start, @NotNull BlockPos end) {
        CompoundTag tag = tool.m_41784_();
        tag.m_128365_(NBT_START_POS, (Tag)NbtUtils.m_129224_((BlockPos)start));
        tag.m_128365_(NBT_END_POS, (Tag)NbtUtils.m_129224_((BlockPos)end));
    }

    public static Tuple<BlockPos, BlockPos> getBounds(@NotNull ItemStack tool) {
        CompoundTag tag = tool.m_41784_();
        BlockPos start = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(NBT_START_POS));
        BlockPos end = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(NBT_END_POS));
        return new Tuple((Object)start, (Object)end);
    }
}

