/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.data.recipe;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.lib.util.NameUtils;

public class ExtendedShapedRecipeBuilder {
    private final RecipeSerializer<?> serializer;
    private final RecipeCategory category;
    private final Collection<Consumer<JsonObject>> extraData = new ArrayList<Consumer<JsonObject>>();
    private final Item result;
    private final int count;
    private final List<String> pattern = new ArrayList<String>();
    private final Map<Character, Ingredient> key = new LinkedHashMap<Character, Ingredient>();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    private boolean hasAdvancementCriterion = false;
    private String group = "";

    private ExtendedShapedRecipeBuilder(RecipeSerializer<?> serializer, RecipeCategory category, ItemLike result, int count) {
        this.serializer = serializer;
        this.category = category;
        this.result = result.m_5456_();
        this.count = count;
    }

    public static ExtendedShapedRecipeBuilder builder(RecipeSerializer<?> serializer, RecipeCategory category, ItemLike result) {
        return ExtendedShapedRecipeBuilder.builder(serializer, category, result, 1);
    }

    public static ExtendedShapedRecipeBuilder builder(RecipeSerializer<?> serializer, RecipeCategory category, ItemLike result, int count) {
        return new ExtendedShapedRecipeBuilder(serializer, category, result, count);
    }

    public static ExtendedShapedRecipeBuilder vanillaBuilder(RecipeCategory category, ItemLike result) {
        return ExtendedShapedRecipeBuilder.vanillaBuilder(category, result, 1);
    }

    public static ExtendedShapedRecipeBuilder vanillaBuilder(RecipeCategory category, ItemLike result, int count) {
        return new ExtendedShapedRecipeBuilder(RecipeSerializer.f_44076_, category, result, count);
    }

    protected void serializeExtra(JsonObject json) {
        this.extraData.forEach(consumer -> consumer.accept(json));
    }

    public ExtendedShapedRecipeBuilder addExtraData(Consumer<JsonObject> extraDataIn) {
        this.extraData.add(extraDataIn);
        return this;
    }

    public ExtendedShapedRecipeBuilder define(Character symbol, TagKey<Item> tagIn) {
        return this.define(symbol, Ingredient.m_204132_(tagIn));
    }

    public ExtendedShapedRecipeBuilder define(Character symbol, ItemLike itemIn) {
        return this.define(symbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemIn}));
    }

    public ExtendedShapedRecipeBuilder define(Character symbol, Ingredient ingredientIn) {
        if (this.key.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(symbol, ingredientIn);
        return this;
    }

    public ExtendedShapedRecipeBuilder pattern(String patternIn) {
        if (!this.pattern.isEmpty() && patternIn.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternIn);
        return this;
    }

    public ExtendedShapedRecipeBuilder unlockedBy(String name, CriterionTriggerInstance criterionIn) {
        this.advancementBuilder.m_138386_(name, criterionIn);
        this.hasAdvancementCriterion = true;
        return this;
    }

    public ExtendedShapedRecipeBuilder group(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, NameUtils.fromItem((ItemLike)this.result));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        this.ensureValid(id);
        if (this.hasAdvancementCriterion && !this.advancementBuilder.m_138405_().isEmpty()) {
            this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        }
        ResourceLocation advancementId = new ResourceLocation(id.m_135827_(), "recipes/" + this.category.m_247710_() + "/" + id.m_135815_());
        consumer.accept(new Result(id, this, advancementId));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        HashSet set = Sets.newHashSet(this.key.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.key.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
        if (this.pattern.size() == 1 && this.pattern.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + id + " only takes in a single item - should it be a shapeless recipe instead?");
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ExtendedShapedRecipeBuilder builder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, ExtendedShapedRecipeBuilder builder, ResourceLocation advancementId) {
            this.id = id;
            this.builder = builder;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.builder.group.isEmpty()) {
                json.addProperty("group", this.builder.group);
            }
            JsonArray pattern = new JsonArray();
            this.builder.pattern.forEach(arg_0 -> ((JsonArray)pattern).add(arg_0));
            json.add("pattern", (JsonElement)pattern);
            JsonObject key = new JsonObject();
            this.builder.key.forEach((c, ingredient) -> key.add(String.valueOf(c), ingredient.m_43942_()));
            json.add("key", (JsonElement)key);
            JsonObject result = new JsonObject();
            result.addProperty("item", NameUtils.fromItem((ItemLike)this.builder.result).toString());
            if (this.builder.count > 1) {
                result.addProperty("count", (Number)this.builder.count);
            }
            json.add("result", (JsonElement)result);
            this.builder.serializeExtra(json);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.builder.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.builder.hasAdvancementCriterion ? this.builder.advancementBuilder.m_138400_() : null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.builder.hasAdvancementCriterion ? this.advancementId : null;
        }
    }
}

