/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public class UseItemTrigger
implements CriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("silentlib", "use_item");
    private final Map<PlayerAdvancements, Listeners> listeners = new HashMap<PlayerAdvancements, Listeners>();

    public ResourceLocation m_7295_() {
        return ID;
    }

    public void m_6467_(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener<Instance> listenerIn) {
        Listeners triggerListeners = this.listeners.get(playerAdvancementsIn);
        if (triggerListeners == null) {
            triggerListeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, triggerListeners);
        }
        triggerListeners.add(listenerIn);
    }

    public void m_6468_(PlayerAdvancements playerAdvancementsIn, CriterionTrigger.Listener<Instance> listenerIn) {
        Listeners triggerListeners = this.listeners.get(playerAdvancementsIn);
        if (triggerListeners != null) {
            triggerListeners.remove(listenerIn);
            if (triggerListeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void m_5656_(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance createInstance(JsonObject json, DeserializationContext p_230307_2_) {
        ItemPredicate itempredicate = ItemPredicate.m_45051_((JsonElement)json.get("item"));
        Target target = Target.fromString(GsonHelper.m_13851_((JsonObject)json, (String)"target", (String)"any"));
        return new Instance(itempredicate, target);
    }

    public void trigger(ServerPlayer player, ItemStack stack, Target target) {
        Listeners triggerListeners = this.listeners.get(player.m_8960_());
        if (triggerListeners != null) {
            triggerListeners.trigger(stack, target);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<CriterionTrigger.Listener<Instance>> listeners = new HashSet<CriterionTrigger.Listener<Instance>>();

        Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(CriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(ItemStack stack, Target target) {
            ArrayList<CriterionTrigger.Listener<Instance>> list = null;
            for (CriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.m_13685_()).test(stack, target)) continue;
                if (list == null) {
                    list = new ArrayList<CriterionTrigger.Listener<Instance>>();
                }
                list.add(listener);
            }
            if (list != null) {
                for (CriterionTrigger.Listener listener : list) {
                    listener.m_13686_(this.playerAdvancements);
                }
            }
        }
    }

    public static enum Target {
        BLOCK,
        ENTITY,
        ITEM,
        ANY;


        static Target fromString(String str) {
            for (Target t : Target.values()) {
                if (!t.name().equalsIgnoreCase(str)) continue;
                return t;
            }
            return ANY;
        }
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        ItemPredicate itempredicate;
        Target target;

        Instance(ItemPredicate itempredicate, Target target) {
            super(ID, ContextAwarePredicate.f_285567_);
            this.itempredicate = itempredicate;
            this.target = target;
        }

        public static Instance instance(ItemPredicate predicate, Target target) {
            return new Instance(predicate, target);
        }

        public boolean test(ItemStack stack, Target target) {
            return this.itempredicate.m_45049_(stack) && (this.target == target || this.target == Target.ANY);
        }

        public JsonObject m_7683_(SerializationContext p_230240_1_) {
            JsonObject json = new JsonObject();
            json.add("item", this.itempredicate.m_45048_());
            json.addProperty("target", this.target.name());
            return json;
        }
    }
}

