/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.advancements.LibTriggers;
import net.silentchaos512.lib.command.internal.DisplayNBTCommand;
import net.silentchaos512.lib.command.internal.TeleportCommand;
import net.silentchaos512.lib.crafting.ingredient.ExclusionIngredient;
import net.silentchaos512.lib.crafting.recipe.DamageItemRecipe;
import net.silentchaos512.lib.data.recipe.test.TestRecipeProvider;
import net.silentchaos512.lib.item.ILeftClickItem;
import net.silentchaos512.lib.network.internal.SilentLibNetwork;

public class SideProxy {
    SideProxy() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::gatherData);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imcEnqueue);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imcProcess);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerRecipeSerializers);
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterCommands);
        SilentLibNetwork.init();
        LibTriggers.init();
        ILeftClickItem.EventHandler.init();
        this.registerIngredientSerializers();
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.addProvider(true, (DataProvider)new TestRecipeProvider(gen));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void imcEnqueue(InterModEnqueueEvent event) {
    }

    private void imcProcess(InterModProcessEvent event) {
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        DisplayNBTCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        TeleportCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    private void registerRecipeSerializers(RegisterEvent event) {
        if (!event.getRegistryKey().equals((Object)ForgeRegistries.RECIPE_SERIALIZERS.getRegistryKey())) {
            return;
        }
        event.getForgeRegistry().register(SilentLib.getId("damage_item"), DamageItemRecipe.SERIALIZER);
    }

    private void registerIngredientSerializers() {
        CraftingHelper.register((ResourceLocation)ExclusionIngredient.Serializer.NAME, (IIngredientSerializer)ExclusionIngredient.Serializer.INSTANCE);
    }

    static class Server
    extends SideProxy {
        Server() {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverSetup);
        }

        private void serverSetup(FMLDedicatedServerSetupEvent event) {
        }
    }

    static class Client
    extends SideProxy {
        Client() {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        }

        private void clientSetup(FMLClientSetupEvent event) {
        }
    }
}

