/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.setup;

import java.util.Arrays;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.gear.block.charger.ChargerTileEntity;
import net.silentchaos512.gear.block.compounder.CompounderTileEntity;
import net.silentchaos512.gear.block.grader.GraderTileEntity;
import net.silentchaos512.gear.block.press.MetalPressTileEntity;
import net.silentchaos512.gear.block.salvager.SalvagerTileEntity;
import net.silentchaos512.gear.crafting.recipe.compounder.FabricCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.GemCompoundingRecipe;
import net.silentchaos512.gear.crafting.recipe.compounder.MetalCompoundingRecipe;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.block.IBlockProvider;

public final class SgBlockEntities {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"silentgear");
    public static final RegistryObject<BlockEntityType<GraderTileEntity>> MATERIAL_GRADER = SgBlockEntities.register("material_grader", GraderTileEntity::new, new IBlockProvider[]{SgBlocks.MATERIAL_GRADER});
    public static final RegistryObject<BlockEntityType<CompounderTileEntity<MetalCompoundingRecipe>>> METAL_ALLOYER = SgBlockEntities.register("metal_alloyer", (pos, state) -> new CompounderTileEntity<MetalCompoundingRecipe>(Const.METAL_COMPOUNDER_INFO, pos, state), new IBlockProvider[]{SgBlocks.METAL_ALLOYER});
    public static final RegistryObject<BlockEntityType<MetalPressTileEntity>> METAL_PRESS = SgBlockEntities.register("metal_press", MetalPressTileEntity::new, new IBlockProvider[]{SgBlocks.METAL_PRESS});
    public static final RegistryObject<BlockEntityType<CompounderTileEntity<GemCompoundingRecipe>>> RECRYSTALLIZER = SgBlockEntities.register("recrystallizer", (pos, state) -> new CompounderTileEntity<GemCompoundingRecipe>(Const.GEM_COMPOUNDER_INFO, pos, state), new IBlockProvider[]{SgBlocks.RECRYSTALLIZER});
    public static final RegistryObject<BlockEntityType<CompounderTileEntity<FabricCompoundingRecipe>>> REFABRICATOR = SgBlockEntities.register("refabricator", (pos, state) -> new CompounderTileEntity<FabricCompoundingRecipe>(Const.FABRIC_COMPOUNDER_INFO, pos, state), new IBlockProvider[]{SgBlocks.REFABRICATOR});
    public static final RegistryObject<BlockEntityType<SalvagerTileEntity>> SALVAGER = SgBlockEntities.register("salvager", SalvagerTileEntity::new, new IBlockProvider[]{SgBlocks.SALVAGER});
    public static final RegistryObject<BlockEntityType<ChargerTileEntity>> STARLIGHT_CHARGER = SgBlockEntities.register("starlight_charger", ChargerTileEntity::createStarlightCharger, new IBlockProvider[]{SgBlocks.STARLIGHT_CHARGER});

    private SgBlockEntities() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderers(FMLClientSetupEvent event) {
    }

    private static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> register(String name, BlockEntityType.BlockEntitySupplier<T> factory, IBlockProvider ... blocks) {
        return BLOCK_ENTITIES.register(name, () -> {
            Block[] validBlocks = (Block[])Arrays.stream(blocks).map(IBlockProvider::asBlock).toArray(Block[]::new);
            return BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)factory, (Block[])validBlocks).m_58966_(null);
        });
    }
}

