/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.setup;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.lib.util.NameUtils;

@Mod.EventBusSubscriber(modid="silentgear")
public final class NerfedGear {
    public static final List<String> DEFAULT_ITEMS = ImmutableList.of((Object)"diamond_axe", (Object)"iron_axe", (Object)"golden_axe", (Object)"stone_axe", (Object)"wooden_axe", (Object)"diamond_hoe", (Object)"iron_hoe", (Object)"golden_hoe", (Object)"stone_hoe", (Object)"wooden_hoe", (Object)"diamond_pickaxe", (Object)"iron_pickaxe", (Object[])new String[]{"golden_pickaxe", "stone_pickaxe", "wooden_pickaxe", "diamond_shovel", "iron_shovel", "golden_shovel", "stone_shovel", "wooden_shovel", "diamond_sword", "iron_sword", "golden_sword", "stone_sword", "wooden_sword"});

    private NerfedGear() {
    }

    public static void init() {
        Field maxDamageField;
        try {
            maxDamageField = ObfuscationReflectionHelper.findField(Item.class, (String)"f_41371_");
            maxDamageField.setAccessible(true);
        }
        catch (Exception ex) {
            SilentGear.LOGGER.error("Field to get Item maxDamage field via reflection");
            SilentGear.LOGGER.catching((Throwable)ex);
            return;
        }
        for (Item item : ForgeRegistries.ITEMS) {
            if (!NerfedGear.isNerfedItem(item)) continue;
            SilentGear.LOGGER.debug("Try nerf durability of {}", (Object)NameUtils.fromItem((ItemLike)item));
            try {
                int maxDamage = (Integer)maxDamageField.get(item);
                int newMax = Mth.m_14045_((int)((int)((double)maxDamage * (Double)Config.Common.nerfedItemDurabilityMulti.get())), (int)1, (int)maxDamage);
                maxDamageField.set(item, newMax);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isNerfedItem(Item item) {
        return item.m_41465_() && Config.Common.isNerfedItem(item);
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack heldItem = event.getEntity().m_21205_();
        if (NerfedGear.isNerfedItem(heldItem.m_41720_())) {
            float newSpeed = event.getNewSpeed() * ((Double)Config.Common.nerfedItemHarvestSpeedMulti.get()).floatValue();
            event.setNewSpeed(Math.max(newSpeed, 1.0f));
        }
    }
}

