/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.item.gear.GearDiggerItem;
import net.silentchaos512.gear.util.GearHelper;

public class GearSickleItem
extends GearDiggerItem {
    private static final int DURABILITY_USAGE = 3;
    private static final int BREAK_RANGE = 4;
    private static final int HARVEST_RANGE = 2;
    private static final Map<Block, BlockState> HARVEST_STATES = new HashMap<Block, BlockState>();

    public static void putHarvestState(Block block, BlockState state) {
        HARVEST_STATES.put(block, state);
    }

    public GearSickleItem(GearType gearType) {
        super(gearType, (TagKey<Block>)BlockTags.f_13035_, GearHelper.getBaseItemProperties());
    }

    private static boolean canRightClickHarvestBlock(BlockState state) {
        Block block = state.m_60734_();
        return block instanceof IPlantable && block instanceof BonemealableBlock;
    }

    private static boolean tryHarvest(ServerLevel world, BlockPos pos, BlockState state, Player player, ItemStack sickle, int fortune) {
        Block block = state.m_60734_();
        BonemealableBlock growable = (BonemealableBlock)block;
        if (!growable.m_7370_((LevelReader)world, pos, state, world.f_46443_)) {
            NonNullList drops = NonNullList.m_122779_();
            drops.addAll((Collection)Block.m_49874_((BlockState)state, (ServerLevel)world, (BlockPos)pos, null, (Entity)player, (ItemStack)sickle));
            boolean foundSeed = false;
            for (ItemStack drop : drops) {
                Item item = drop.m_41720_();
                if (!foundSeed && item instanceof BlockItem && ((BlockItem)item).m_40614_() == block) {
                    foundSeed = true;
                    continue;
                }
                Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)drop);
            }
            world.m_7731_(pos, HARVEST_STATES.getOrDefault(block, block.m_49966_()), 2);
            return true;
        }
        return false;
    }

    @Override
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        ItemStack sickle = context.m_43722_();
        if (GearHelper.isBroken(sickle) || !(context.m_43725_() instanceof ServerLevel)) {
            return InteractionResult.PASS;
        }
        ServerLevel world = (ServerLevel)context.m_43725_();
        BlockState state = world.m_8055_(pos = context.m_8083_());
        if (!GearSickleItem.canRightClickHarvestBlock(state)) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        int fortune = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)sickle);
        int harvestCount = 0;
        int radius = 2;
        for (int z = pos.m_123343_() - 2; z <= pos.m_123343_() + 2; ++z) {
            for (int x = pos.m_123341_() - 2; x <= pos.m_123341_() + 2; ++x) {
                BlockPos target = new BlockPos(x, pos.m_123342_(), z);
                state = world.m_8055_(target);
                if (!GearSickleItem.canRightClickHarvestBlock(state) || !GearSickleItem.tryHarvest(world, target, state, player, sickle, fortune)) continue;
                ++harvestCount;
            }
        }
        if (harvestCount > 0) {
            GearHelper.attemptDamage(sickle, 3, (LivingEntity)player, context.m_43724_());
            player.m_36399_(0.02f);
            return InteractionResult.SUCCESS;
        }
        return GearHelper.onItemUse(context);
    }

    public boolean onBlockStartBreak(ItemStack sickle, BlockPos pos, Player player) {
        return this.onSickleStartBreak(sickle, pos, player, 4);
    }

    boolean onSickleStartBreak(ItemStack sickle, BlockPos pos, Player player, int range) {
        if (GearHelper.isBroken(sickle)) {
            return false;
        }
        Level world = player.m_9236_();
        BlockState state = world.m_8055_(pos);
        if (!state.m_204336_(BlockTags.f_144281_)) {
            return false;
        }
        int blocksBroken = 1;
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        for (int xPos = x - range; xPos <= x + range; ++xPos) {
            for (int zPos = z - range; zPos <= z + range; ++zPos) {
                BlockPos target = new BlockPos(xPos, y, zPos);
                if (xPos == x && zPos == z || world.m_8055_(target) != state || !GearSickleItem.breakExtraBlock(sickle, world, target, player)) continue;
                ++blocksBroken;
            }
        }
        return super.onBlockStartBreak(sickle, pos, player);
    }

    private static boolean breakExtraBlock(ItemStack sickle, Level world, BlockPos pos, Player player) {
        boolean canceled;
        if (world.m_46859_(pos) || !(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer playerMP = (ServerPlayer)player;
        BlockState state = player.m_9236_().m_8055_(pos);
        Block block = state.m_60734_();
        int xpDropped = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)playerMP.f_8941_.m_9290_(), (ServerPlayer)playerMP, (BlockPos)pos);
        boolean bl = canceled = xpDropped == -1;
        if (canceled) {
            return false;
        }
        if (playerMP.m_150110_().f_35937_) {
            block.m_5707_(world, pos, state, player);
            if (block.onDestroyedByPlayer(state, world, pos, (Player)playerMP, false, state.m_60819_())) {
                block.m_6786_((LevelAccessor)world, pos, state);
            }
            if (!world.f_46443_) {
                playerMP.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, pos));
            }
            return true;
        }
        if (!world.f_46443_ && world instanceof ServerLevel) {
            block.m_5707_(world, pos, state, (Player)playerMP);
            if (block.onDestroyedByPlayer(state, world, pos, (Player)playerMP, true, state.m_60819_())) {
                block.m_6786_((LevelAccessor)world, pos, state);
                block.m_6240_(world, player, pos, state, null, sickle);
                block.m_49805_((ServerLevel)world, pos, xpDropped);
            }
            playerMP.f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, pos));
        } else {
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            if (block.onDestroyedByPlayer(state, world, pos, (Player)playerMP, true, state.m_60819_())) {
                block.m_6786_((LevelAccessor)world, pos, state);
            }
            sickle.m_41686_(world, state, pos, (Player)playerMP);
        }
        return true;
    }

    @Override
    public int getDamageOnBlockBreak(ItemStack gear, Level world, BlockState state, BlockPos pos) {
        return 3;
    }

    static {
        GearSickleItem.putHarvestState(Blocks.f_50685_, (BlockState)Blocks.f_50685_.m_49966_().m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1)));
    }
}

