/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.item.ICycleItem;
import net.silentchaos512.gear.network.KeyPressOnItemPacket;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.utils.Color;

public class ModKitItem
extends Item
implements ICycleItem {
    private static final String NBT_SELECTED = "SelectedType";

    public ModKitItem(Item.Properties properties) {
        super(properties);
    }

    public static PartType getSelectedType(ItemStack stack) {
        String key = stack.m_41784_().m_128461_(NBT_SELECTED);
        return PartType.getNonNull(new ResourceLocation(key));
    }

    public static void setSelectedType(ItemStack stack, PartType type) {
        stack.m_41784_().m_128359_(NBT_SELECTED, type.getName().toString());
    }

    @Override
    public void onCycleKeyPress(ItemStack stack, KeyPressOnItemPacket.Type direction) {
        PartType selected = ModKitItem.getSelectedType(stack);
        List<PartType> types = ModKitItem.getRemovableTypes();
        if (types.isEmpty()) {
            return;
        }
        if (selected == PartType.NONE) {
            if (direction == KeyPressOnItemPacket.Type.CYCLE_BACK) {
                ModKitItem.setSelectedType(stack, types.get(types.size() - 1));
            } else if (direction == KeyPressOnItemPacket.Type.CYCLE_NEXT) {
                ModKitItem.setSelectedType(stack, types.get(0));
            }
        } else {
            int index = types.indexOf(selected) + direction.direction;
            if (index < 0) {
                index = types.size() - 1;
            }
            if (index >= types.size()) {
                index = 0;
            }
            ModKitItem.setSelectedType(stack, types.get(index));
        }
    }

    private static List<PartType> getRemovableTypes() {
        ArrayList<PartType> list = new ArrayList<PartType>();
        for (PartType partType : PartType.getValues()) {
            if (!partType.isRemovable()) continue;
            list.add(partType);
        }
        return list;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        PartType selected = ModKitItem.getSelectedType(stack);
        tooltip.add((Component)TextUtil.withColor(TextUtil.translate("item", "mod_kit.selected"), Color.SKYBLUE).m_7220_((Component)selected.getDisplayName(0).m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)TextUtil.translate("item", "mod_kit.keyHint", TextUtil.withColor(TextUtil.keyBinding(KeyTracker.CYCLE_BACK), Color.AQUAMARINE), TextUtil.withColor(TextUtil.keyBinding(KeyTracker.CYCLE_NEXT), Color.AQUAMARINE)));
        if (flagIn.m_7050_()) {
            MutableComponent text = Component.m_237113_((String)("Removable types: " + ModKitItem.getRemovableTypes().size()));
            tooltip.add((Component)TextUtil.withColor(text, ChatFormatting.DARK_GRAY));
        }
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return itemStack.m_41777_();
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }
}

