/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.client.util.ModelPropertiesHelper;
import net.silentchaos512.gear.item.gear.GearCrossbowItem;
import net.silentchaos512.lib.client.gui.DebugRenderOverlay;

public class DebugOverlay
extends DebugRenderOverlay {
    private static final int SPLIT_WIDTH = 160;
    private static final float TEXT_SCALE = 0.7f;

    @Nonnull
    public List<String> getDebugText() {
        EntityHitResult ert;
        Entity entity;
        ArrayList<String> list = new ArrayList<String>();
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return list;
        }
        ItemStack heldItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (heldItem.m_41619_()) {
            return list;
        }
        Item item = heldItem.m_41720_();
        if (item instanceof GearCrossbowItem) {
            float pull = ModelPropertiesHelper.getValue(heldItem, new ResourceLocation("pull"), mc.f_91073_, (LivingEntity)player);
            float pulling = ModelPropertiesHelper.getValue(heldItem, new ResourceLocation("pulling"), mc.f_91073_, (LivingEntity)player);
            float charged = ModelPropertiesHelper.getValue(heldItem, new ResourceLocation("charged"), mc.f_91073_, (LivingEntity)player);
            float firework = ModelPropertiesHelper.getValue(heldItem, new ResourceLocation("firework"), mc.f_91073_, (LivingEntity)player);
            list.add(String.format("pull=%.1f", Float.valueOf(pull)));
            list.add(String.format("pulling=%.1f", Float.valueOf(pulling)));
            list.add(String.format("charged=%.1f", Float.valueOf(charged)));
            list.add(String.format("firework=%.1f", Float.valueOf(firework)));
            list.add(String.format("chargeTime=%d", GearCrossbowItem.getChargeTime(heldItem)));
            return list;
        }
        HitResult rt = mc.f_91077_;
        if (rt != null && rt.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult brt = (BlockHitResult)rt;
            Entity renderViewEntity = mc.m_91288_();
            if (renderViewEntity != null) {
                BlockPos pos = brt.m_82425_();
                BlockState blockState = renderViewEntity.m_9236_().m_8055_(pos);
            }
        } else if (rt != null && rt.m_6662_() == HitResult.Type.ENTITY && (entity = (ert = (EntityHitResult)rt).m_82443_()) instanceof LivingEntity) {
            list.add(String.format("%s", entity.m_6302_()));
            list.add(String.format("health = %.3f", Float.valueOf(((LivingEntity)entity).m_21223_())));
        }
        return list;
    }

    private static void addAttributeInfo(List<String> list, Player player, Attribute attribute) {
        AttributeInstance attribute1 = player.m_21051_(attribute);
        list.add(String.format("%s=%.1f (%dx mods)", attribute, attribute1.m_22135_(), attribute1.m_22122_().size()));
    }

    public float getTextScale() {
        return 0.7f;
    }

    public int getSplitWidth() {
        return 160;
    }

    public boolean isHidden() {
        return !SilentGear.isDevBuild();
    }
}

