/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.util;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.api.util.IGearComponent;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.api.util.StatGearKey;

public interface IGearComponentInstance<T extends IGearComponent<?>> {
    @Nullable
    public T get();

    public ResourceLocation getId();

    public ItemStack getItem();

    public MaterialList getMaterials();

    public float getStat(PartType var1, StatGearKey var2, ItemStack var3);

    default public float getStat(PartType partType, StatGearKey key) {
        return this.getStat(partType, key, ItemStack.f_41583_);
    }

    public Collection<StatInstance> getStatModifiers(PartType var1, StatGearKey var2, ItemStack var3);

    default public Collection<StatInstance> getStatModifiers(PartType partType, StatGearKey key) {
        return this.getStatModifiers(partType, key, ItemStack.f_41583_);
    }

    public Collection<TraitInstance> getTraits(PartType var1, GearType var2, ItemStack var3);

    default public Collection<TraitInstance> getTraits(PartGearKey key, ItemStack gear) {
        return this.getTraits(key.getPartType(), key.getGearType(), gear);
    }

    default public Collection<TraitInstance> getTraits(PartType partType) {
        return this.getTraits(partType, GearType.ALL, ItemStack.f_41583_);
    }

    default public Component getDisplayName(PartType type) {
        return this.getDisplayName(type, ItemStack.f_41583_);
    }

    public Component getDisplayName(PartType var1, ItemStack var2);

    public int getNameColor(PartType var1, GearType var2);

    default public boolean containsMaterial(DataResource<IMaterial> materialIn) {
        if (materialIn.isPresent()) {
            for (IGearComponentInstance mat : this.getMaterials()) {
                IMaterial material = (IMaterial)mat.get();
                if (material == null || !material.equals(materialIn.get())) continue;
                return true;
            }
        }
        return false;
    }
}

