/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.traits;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.util.TextUtil;

public interface ITrait {
    public ResourceLocation getId();

    public int getMaxLevel();

    public Collection<ITraitCondition> getConditions();

    public boolean willCancelWith(ITrait var1);

    default public int getCanceledLevel(int level, ITrait other, int otherLevel) {
        if (this.willCancelWith(other)) {
            int diff = level - otherLevel;
            return diff < 0 ? Mth.m_14045_((int)diff, (int)(-other.getMaxLevel()), (int)0) : Mth.m_14045_((int)diff, (int)0, (int)this.getMaxLevel());
        }
        return level;
    }

    default public void retainData(@Nullable ITrait oldTrait) {
    }

    public MutableComponent getDisplayName(int var1);

    public MutableComponent getDescription(int var1);

    default public boolean isHidden() {
        return false;
    }

    default public boolean showInTooltip(TooltipFlag flag) {
        return !this.isHidden() || flag.m_7050_();
    }

    @Deprecated
    default public void addInformation(int level, List<Component> tooltip) {
        this.addInformation(level, tooltip, (TooltipFlag)TooltipFlag.f_256752_);
    }

    default public void addInformation(int level, List<Component> tooltip, TooltipFlag flag) {
        this.addInformation(level, tooltip, flag, t -> t);
    }

    default public void addInformation(int level, List<Component> tooltip, TooltipFlag flag, Function<Component, Component> affixFirst) {
        if (!this.showInTooltip(flag)) {
            return;
        }
        MutableComponent displayName = TextUtil.withColor(this.getDisplayName(level), this.isHidden() ? ChatFormatting.DARK_GRAY : ChatFormatting.GRAY);
        displayName.m_7383_().m_131140_(ChatFormatting.ITALIC);
        tooltip.add(affixFirst.apply((Component)displayName));
        if (KeyTracker.isDisplayTraitsDown() && !((Boolean)Config.Client.vanillaStyleTooltips.get()).booleanValue()) {
            MutableComponent description = TextUtil.withColor(this.getDescription(level), ChatFormatting.DARK_GRAY);
            tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)description));
        }
    }

    public ITraitSerializer<?> getSerializer();

    public float onAttackEntity(TraitActionContext var1, LivingEntity var2, float var3);

    public float onDurabilityDamage(TraitActionContext var1, int var2);

    public void onGearCrafted(TraitActionContext var1);

    public void onRecalculatePre(TraitActionContext var1);

    public void onRecalculatePost(TraitActionContext var1);

    public float onGetStat(TraitActionContext var1, ItemStat var2, float var3, float var4);

    public void onGetAttributeModifiers(TraitActionContext var1, Multimap<Attribute, AttributeModifier> var2, String var3);

    @Deprecated
    default public void onGetAttributeModifiers(TraitActionContext context, Multimap<Attribute, AttributeModifier> modifiers, EquipmentSlot slot) {
        this.onGetAttributeModifiers(context, modifiers, slot.m_20751_());
    }

    public InteractionResult onItemUse(UseOnContext var1, int var2);

    public void onItemSwing(ItemStack var1, LivingEntity var2, int var3);

    public void onUpdate(TraitActionContext var1, boolean var2);

    public ItemStack addLootDrops(TraitActionContext var1, ItemStack var2);

    default public CompoundTag write(int level) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Name", this.getId().toString());
        tag.m_128344_("Level", (byte)level);
        return tag;
    }

    default public Collection<String> getCancelsWithSet() {
        return Collections.emptySet();
    }

    default public Collection<String> getExtraWikiLines() {
        return Collections.emptyList();
    }
}

