/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.data.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.api.ApiConst;
import net.silentchaos512.gear.api.data.trait.TraitBuilder;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.lib.util.TimeUtils;

public class TargetEffectTraitBuilder
extends TraitBuilder {
    private final Map<GearType, Map<Integer, List<MobEffectInstance>>> potions = new LinkedHashMap<GearType, Map<Integer, List<MobEffectInstance>>>();

    public TargetEffectTraitBuilder(DataResource<ITrait> trait, int maxLevel) {
        this(trait.getId(), maxLevel);
    }

    public TargetEffectTraitBuilder(ResourceLocation traitId, int maxLevel) {
        super(traitId, maxLevel, (ResourceLocation)ApiConst.TARGET_EFFECT_TRAIT_ID);
    }

    public TargetEffectTraitBuilder addEffect(GearType gearType, int traitLevel, MobEffect effect, int amplifier, float durationInSeconds) {
        this.potions.computeIfAbsent(gearType, t -> new LinkedHashMap()).computeIfAbsent(traitLevel, l -> new ArrayList()).add(new MobEffectInstance(effect, TimeUtils.ticksFromSeconds((float)durationInSeconds), amplifier));
        return this;
    }

    public TargetEffectTraitBuilder withDurationByLevel(GearType gearType, MobEffect effect, int amplifier, float baseDurationInSeconds) {
        for (int i = 1; i <= this.maxLevel; ++i) {
            this.addEffect(gearType, i, effect, amplifier, (float)i * baseDurationInSeconds);
        }
        return this;
    }

    @Override
    public JsonObject serialize() {
        if (this.potions.isEmpty()) {
            throw new IllegalStateException("Target effect trait '" + this.getTraitId() + "' has no effects");
        }
        JsonObject json = super.serialize();
        JsonObject effectsJson = new JsonObject();
        this.potions.forEach((gearType, map) -> {
            EffectMap effectMap = new EffectMap((Map<Integer, List<MobEffectInstance>>)map);
            effectsJson.add(gearType.getName(), (JsonElement)effectMap.serialize());
        });
        json.add("effects", (JsonElement)effectsJson);
        return json;
    }

    public static class EffectMap {
        private final Map<Integer, List<MobEffectInstance>> effects = new LinkedHashMap<Integer, List<MobEffectInstance>>();

        public EffectMap(Map<Integer, List<MobEffectInstance>> effects) {
            this.effects.putAll(effects);
        }

        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            for (Map.Entry<Integer, List<MobEffectInstance>> entry : this.effects.entrySet()) {
                int level = entry.getKey();
                List<MobEffectInstance> list = entry.getValue();
                JsonArray array = new JsonArray();
                for (MobEffectInstance inst : list) {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("effect", Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)inst.m_19544_())).toString());
                    obj.addProperty("amplifier", (Number)inst.m_19564_());
                    obj.addProperty("duration", (Number)Float.valueOf((float)inst.m_19557_() / 20.0f));
                    array.add((JsonElement)obj);
                }
                json.add(String.valueOf(level), (JsonElement)array);
            }
            return json;
        }
    }
}

