/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.data.material;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.silentchaos512.gear.api.data.material.MaterialBuilder;
import net.silentchaos512.gear.data.DataGenerators;
import org.jetbrains.annotations.NotNull;

public abstract class MaterialsProviderBase
implements DataProvider {
    protected final DataGenerator generator;
    protected final String modId;

    public MaterialsProviderBase(DataGenerator generator, String modId) {
        this.generator = generator;
        this.modId = modId;
    }

    protected abstract Collection<MaterialBuilder> getMaterials();

    protected ResourceLocation modId(String path) {
        return new ResourceLocation(this.modId, path);
    }

    protected static ResourceLocation forgeId(String path) {
        return new ResourceLocation("forge", path);
    }

    @NotNull
    public String m_6055_() {
        return "Silent Gear Materials: " + this.modId;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        Path outputFolder = this.generator.getPackOutput().m_245114_();
        HashSet set = Sets.newHashSet();
        ArrayList list = new ArrayList();
        this.getMaterials().forEach(builder -> {
            if (!set.add(builder.getId())) {
                throw new IllegalStateException("Duplicate material: " + builder.getId());
            }
            Path path = outputFolder.resolve(String.format("data/%s/silentgear_materials/%s.json", builder.getId().m_135827_(), builder.getId().m_135815_()));
            list.add(DataGenerators.saveStable(cache, (JsonElement)builder.serialize(), path));
        });
        return CompletableFuture.allOf(list.toArray(new CompletableFuture[0]));
    }
}

