/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.rsinsertexportupgrade.mixin;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraphEntry;
import com.refinedmods.refinedstorage.api.network.IWirelessTransmitter;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.item.NetworkItem;
import com.refinedmods.refinedstorage.item.WirelessGridItem;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import com.refinedmods.refinedstorageaddons.item.WirelessCraftingGridItem;
import com.ultramega.universalgrid.item.WirelessUniversalGridItem;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.gigabit101.rebornstorage.items.ItemWirelessGrid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={WirelessGridItem.class, WirelessCraftingGridItem.class, WirelessUniversalGridItem.class, ItemWirelessGrid.class})
public abstract class MixinWirelessGridItem
extends Item {
    protected MixinWirelessGridItem(Item.Properties properties) {
        super(properties);
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (!stack.m_41782_() || level.f_46443_) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean inRange = false;
            INetwork network = this.rsInsertExportUpgrade$getNetwork(level.m_7654_(), stack, arg_0 -> ((Player)player).m_213846_(arg_0));
            if (network == null) {
                return;
            }
            for (INetworkNodeGraphEntry entry : network.getNodeGraph().all()) {
                INetworkNode node = entry.getNode();
                if (!(node instanceof IWirelessTransmitter)) continue;
                IWirelessTransmitter transmitter = (IWirelessTransmitter)node;
                if (!network.canRun() || !node.isActive() || ((IWirelessTransmitter)node).getDimension() != player.m_20193_().m_46472_()) continue;
                Vec3 pos = player.m_20182_();
                double distance = Math.sqrt(Math.pow((double)transmitter.getOrigin().m_123341_() - pos.m_7096_(), 2.0) + Math.pow((double)transmitter.getOrigin().m_123342_() - pos.m_7098_(), 2.0) + Math.pow((double)transmitter.getOrigin().m_123343_() - pos.m_7094_(), 2.0));
                if (!(distance < (double)transmitter.getRange())) continue;
                inRange = true;
                break;
            }
            if (!inRange) {
                return;
            }
            if (stack.m_41783_().m_128441_("Inventory_2")) {
                ListTag tagList = stack.m_41783_().m_128437_("Inventory_2", 10);
                for (int i = 0; i < tagList.size(); ++i) {
                    boolean isInsertUpgrade = tagList.m_128728_(i).m_128461_("id").equals(new ResourceLocation("rsinsertexportupgrade", "insert_upgrade").toString());
                    CompoundTag tag = (CompoundTag)tagList.m_128728_(i).m_128423_("tag");
                    if (tag == null) continue;
                    int[] selectedInventorySlots = tag.m_128465_("SelectedInventorySlots");
                    int mode = isInsertUpgrade ? tag.m_128451_("Mode") : -1;
                    for (int j = 0; j < selectedInventorySlots.length; ++j) {
                        if (selectedInventorySlots[j] < 1) continue;
                        int index = j <= 26 ? j + 9 : j - 27;
                        ItemStack itemInInventory = player.m_150109_().m_8020_(index);
                        if (isInsertUpgrade && itemInInventory.m_41720_() == Items.f_41852_ || itemInInventory == stack) continue;
                        List<Item> filters = Arrays.asList(new Item[18]);
                        if (tag.m_128441_("Inventory_0")) {
                            ListTag tagList2 = tag.m_128437_("Inventory_0", 10);
                            for (int k = 0; k < tagList2.size(); ++k) {
                                String itemId = tagList2.m_128728_(k).m_128461_("id");
                                int slot = tagList2.m_128728_(k).m_128451_("Slot");
                                filters.set(slot, (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)));
                            }
                        }
                        if (!filters.isEmpty() && isInsertUpgrade && mode == 0 != filters.contains(itemInInventory.m_41720_())) continue;
                        network.getItemStorageTracker().changed(player, (Object)itemInInventory.m_41777_());
                        if (isInsertUpgrade) {
                            if (network.insertItem(itemInInventory, itemInInventory.m_41613_(), Action.SIMULATE).m_41619_()) {
                                network.insertItem(itemInInventory, itemInInventory.m_41613_(), Action.PERFORM);
                                player.m_150109_().m_6836_(index, ItemStack.f_41583_);
                            }
                        } else {
                            if (filters.isEmpty()) {
                                return;
                            }
                            for (int k = 0; k < filters.size(); ++k) {
                                Optional playerInventory;
                                StackListEntry stackEntry;
                                if (filters.get(k) == null || filters.get(k) == Items.f_41852_ || k != selectedInventorySlots[j] - 1 || (stackEntry = network.getItemStorageCache().getList().getEntry((Object)filters.get(k).m_7968_(), 1)) == null) continue;
                                ItemStack item = (ItemStack)network.getItemStorageCache().getList().get(stackEntry.getId());
                                int maxItemSize = item.m_41720_().getMaxStackSize(item.m_41777_());
                                int size = Math.min(64, maxItemSize);
                                network.getItemStorageTracker().changed(player, (Object)item.m_41777_());
                                ItemStack took = network.extractItem(item, size, Action.SIMULATE);
                                if (took.m_41619_() || !(playerInventory = player.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).resolve()).isPresent()) continue;
                                ItemStack remainder = ((IItemHandler)playerInventory.get()).insertItem(index, took, true);
                                if (remainder.m_41613_() != took.m_41613_()) {
                                    ItemStack inserted = network.extractItem(item, size - remainder.m_41613_(), Action.PERFORM);
                                    ((IItemHandler)playerInventory.get()).insertItem(index, inserted, false);
                                    took.m_41764_(remainder.m_41613_());
                                }
                                if (took.m_41619_() || !this.rsInsertExportUpgrade$insertItemStacked((IItemHandler)playerInventory.get(), index, took, true).m_41619_()) continue;
                                took = network.extractItem(item, size, Action.PERFORM);
                                this.rsInsertExportUpgrade$insertItemStacked((IItemHandler)playerInventory.get(), index, took, false);
                            }
                        }
                        network.getNetworkItemManager().drainEnergy(player, isInsertUpgrade ? RS.SERVER_CONFIG.getWirelessGrid().getInsertUsage() : RS.SERVER_CONFIG.getWirelessGrid().getExtractUsage());
                    }
                }
            }
        }
    }

    @Unique
    @NotNull
    public ItemStack rsInsertExportUpgrade$insertItemStacked(IItemHandler inventory, int slotIndex, @NotNull ItemStack stack, boolean simulate) {
        if (inventory == null || stack.m_41619_()) {
            return stack;
        }
        if (!stack.m_41753_()) {
            return this.rsInsertExportUpgrade$insertItem(inventory, slotIndex, stack, simulate);
        }
        ItemStack slot = inventory.getStackInSlot(slotIndex);
        if (ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)slot, (ItemStack)stack)) {
            stack = inventory.insertItem(slotIndex, stack, simulate);
        }
        if (!stack.m_41619_() && inventory.getStackInSlot(slotIndex).m_41619_()) {
            stack = inventory.insertItem(slotIndex, stack, simulate);
        }
        return stack;
    }

    @Unique
    @NotNull
    public ItemStack rsInsertExportUpgrade$insertItem(IItemHandler dest, int slotIndex, @NotNull ItemStack stack, boolean simulate) {
        if (dest == null || stack.m_41619_()) {
            return stack;
        }
        if ((stack = dest.insertItem(slotIndex, stack, simulate)).m_41619_()) {
            return ItemStack.f_41583_;
        }
        return stack;
    }

    @Unique
    public INetwork rsInsertExportUpgrade$getNetwork(MinecraftServer server, ItemStack stack, Consumer<Component> onError) {
        MutableComponent notFound = Component.m_237115_((String)"misc.refinedstorage.network_item.not_found");
        if (!NetworkItem.isValid((ItemStack)stack)) {
            onError.accept((Component)notFound);
            return null;
        }
        ResourceKey dimension = NetworkItem.getDimension((ItemStack)stack);
        if (dimension == null) {
            onError.accept((Component)notFound);
            return null;
        }
        ServerLevel nodeLevel = server.m_129880_(dimension);
        if (nodeLevel == null) {
            onError.accept((Component)notFound);
            return null;
        }
        BlockPos pos = new BlockPos(NetworkItem.getX((ItemStack)stack), NetworkItem.getY((ItemStack)stack), NetworkItem.getZ((ItemStack)stack));
        if (!nodeLevel.m_46749_(pos)) {
            onError.accept((Component)notFound);
            return null;
        }
        INetwork network = NetworkUtils.getNetworkFromNode((INetworkNode)NetworkUtils.getNodeFromBlockEntity((BlockEntity)nodeLevel.m_7702_(pos)));
        if (network == null) {
            onError.accept((Component)notFound);
            return null;
        }
        return network;
    }
}

