/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsbase.api.screens.data.IModuleDataFactory;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class PacketReturnScreenData {
    private final GlobalPos pos;
    private final Map<Integer, IModuleData> screenData;

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos.m_122646_());
        buf.m_130085_(this.pos.m_122640_().m_135782_());
        buf.writeInt(this.screenData.size());
        for (Map.Entry<Integer, IModuleData> me : this.screenData.entrySet()) {
            buf.writeInt(me.getKey().intValue());
            IModuleData c = me.getValue();
            buf.writeInt(RFToolsUtility.screenModuleRegistry.getShortId(c.getId()));
            c.writeToBuf(buf);
        }
    }

    public GlobalPos getPos() {
        return this.pos;
    }

    public Map<Integer, IModuleData> getScreenData() {
        return this.screenData;
    }

    public PacketReturnScreenData(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        ResourceKey dim = LevelTools.getId((ResourceLocation)buf.m_130281_());
        this.pos = GlobalPos.m_122643_((ResourceKey)dim, (BlockPos)pos);
        int size = buf.readInt();
        this.screenData = new HashMap<Integer, IModuleData>(size);
        for (int i = 0; i < size; ++i) {
            int key = buf.readInt();
            int shortId = buf.readInt();
            String id = RFToolsUtility.screenModuleRegistry.getNormalId(shortId);
            IModuleDataFactory<?> dataFactory = RFToolsUtility.screenModuleRegistry.getModuleDataFactory(id);
            IModuleData data = dataFactory.createData(buf);
            this.screenData.put(key, data);
        }
    }

    public PacketReturnScreenData(GlobalPos pos, Map<Integer, IModuleData> screenData) {
        this.pos = pos;
        this.screenData = screenData;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> ScreenTileEntity.screenData.put(this.getPos(), this.getScreenData()));
        ctx.setPacketHandled(true);
    }
}

