/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOp;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketGraphicsReady {
    private final BlockPos pos;
    private final Map<String, GfxOp> gfxOps;
    private final List<String> orderedOps;

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.gfxOps.size());
        for (Map.Entry<String, GfxOp> entry : this.gfxOps.entrySet()) {
            buf.m_130070_(entry.getKey());
            entry.getValue().writeToBuf(buf);
        }
        buf.writeInt(this.orderedOps.size());
        for (String op : this.orderedOps) {
            buf.m_130070_(op);
        }
    }

    public PacketGraphicsReady(FriendlyByteBuf buf) {
        String key;
        int i;
        this.pos = buf.m_130135_();
        int size = buf.readInt();
        this.gfxOps = new HashMap<String, GfxOp>(size);
        for (i = 0; i < size; ++i) {
            key = buf.m_130136_(Short.MAX_VALUE);
            GfxOp gfxOp = GfxOp.readFromBuf(buf);
            this.gfxOps.put(key, gfxOp);
        }
        size = buf.readInt();
        this.orderedOps = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            key = buf.m_130136_(Short.MAX_VALUE);
            this.orderedOps.add(key);
        }
    }

    public PacketGraphicsReady(ProcessorTileEntity processor) {
        this.pos = processor.m_58899_();
        this.gfxOps = processor.getGfxOps();
        this.orderedOps = processor.getOrderedOps();
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            BlockEntity te = SafeClientTools.getClientWorld().m_7702_(this.pos);
            if (te instanceof ProcessorTileEntity) {
                ProcessorTileEntity processor = (ProcessorTileEntity)te;
                processor.setClientOrderedGfx(this.gfxOps, this.orderedOps);
            }
        });
        ctx.setPacketHandled(true);
    }
}

