/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.api.control.parameters;

import java.util.Objects;
import mcjty.rftoolsbase.api.control.parameters.IParameter;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;

public class Parameter
implements IParameter {
    private final ParameterType parameterType;
    private final ParameterValue parameterValue;

    private Parameter(Builder builder) {
        this.parameterType = builder.parameterType;
        this.parameterValue = builder.parameterValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IParameter parameter = (IParameter)o;
        return this.parameterType == parameter.getParameterType() && Objects.equals(this.parameterValue, parameter.getParameterValue());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.parameterType, this.parameterValue});
    }

    @Override
    public boolean isSet() {
        return this.parameterValue != null && this.parameterValue.getValue() != null;
    }

    @Override
    public ParameterType getParameterType() {
        return this.parameterType;
    }

    @Override
    public ParameterValue getParameterValue() {
        return this.parameterValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ParameterType parameterType;
        private ParameterValue parameterValue;

        public Builder type(ParameterType parameterType) {
            this.parameterType = parameterType;
            return this;
        }

        public Builder value(ParameterValue value) {
            this.parameterValue = value;
            return this;
        }

        public Parameter build() {
            return new Parameter(this);
        }
    }
}

