/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.preview;

import com.refinedmods.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.refinedmods.refinedstorage.api.autocrafting.task.CalculationResultType;
import com.refinedmods.refinedstorage.api.render.IElementDrawers;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ErrorCraftingPreviewElement
implements ICraftingPreviewElement {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "error");
    private final CalculationResultType type;
    private final ItemStack recursedPattern;

    public ErrorCraftingPreviewElement(CalculationResultType type, ItemStack recursedPattern) {
        this.type = type;
        this.recursedPattern = recursedPattern;
    }

    public static ErrorCraftingPreviewElement read(FriendlyByteBuf buf) {
        int errorIdx = buf.readInt();
        CalculationResultType error = errorIdx >= 0 && errorIdx < CalculationResultType.values().length ? CalculationResultType.values()[errorIdx] : CalculationResultType.TOO_COMPLEX;
        ItemStack stack = buf.m_130267_();
        return new ErrorCraftingPreviewElement(error, stack);
    }

    public ItemStack getRecursedPattern() {
        return this.recursedPattern;
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, IElementDrawers drawers) {
    }

    @Override
    public boolean doesDisableTaskStarting() {
        return true;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.m_130055_(this.recursedPattern);
    }

    public CalculationResultType getType() {
        return this.type;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }
}

