/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.ICraftingManager;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorListener;
import com.refinedmods.refinedstorage.api.autocrafting.task.CalculationResultType;
import com.refinedmods.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICalculationResult;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.refinedmods.refinedstorage.api.autocrafting.task.ICraftingTaskFactory;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraphEntry;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.autocrafting.task.v6.calculator.CalculationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftingManager
implements ICraftingManager {
    private static final int THROTTLE_DELAY_MS = 3000;
    private static final Logger LOGGER = LogManager.getLogger(CraftingManager.class);
    private static final String NBT_TASKS = "Tasks";
    private static final String NBT_TASK_TYPE = "Type";
    private static final String NBT_TASK_DATA = "Task";
    private final INetwork network;
    private final Map<Component, List<IItemHandlerModifiable>> containerInventories = new LinkedHashMap<Component, List<IItemHandlerModifiable>>();
    private final Map<ICraftingPattern, Set<ICraftingPatternContainer>> patternToContainer = new HashMap<ICraftingPattern, Set<ICraftingPatternContainer>>();
    private final List<ICraftingPattern> patterns = new ArrayList<ICraftingPattern>();
    private final Map<FluidStackKey, ICraftingPattern> fluidPatternsByOutput = new HashMap<FluidStackKey, ICraftingPattern>();
    private final Map<ItemStackKey, ICraftingPattern> itemPatternsByOutput = new HashMap<ItemStackKey, ICraftingPattern>();
    private final Map<UUID, ICraftingTask> tasks = new LinkedHashMap<UUID, ICraftingTask>();
    private final List<ICraftingTask> tasksToAdd = new ArrayList<ICraftingTask>();
    private final List<UUID> tasksToCancel = new ArrayList<UUID>();
    private final Map<Object, Long> throttledRequesters = new HashMap<Object, Long>();
    private final Set<ICraftingMonitorListener> listeners = new HashSet<ICraftingMonitorListener>();
    private ListTag tasksToRead;

    public CraftingManager(INetwork network) {
        this.network = network;
    }

    @Override
    public Collection<ICraftingTask> getTasks() {
        return this.tasks.values();
    }

    @Override
    @Nullable
    public ICraftingTask getTask(UUID id) {
        return this.tasks.get(id);
    }

    @Override
    public Map<Component, List<IItemHandlerModifiable>> getNamedContainers() {
        return this.containerInventories;
    }

    @Override
    public void start(@Nonnull ICraftingTask task) {
        task.start();
        this.tasksToAdd.add(task);
        this.network.markDirty();
    }

    @Override
    public void cancel(@Nullable UUID id) {
        if (id == null) {
            this.tasksToCancel.addAll(this.tasks.keySet());
        } else {
            this.tasksToCancel.add(id);
        }
        this.network.markDirty();
    }

    @Override
    public ICalculationResult create(ItemStack stack, int quantity) {
        ICraftingPattern pattern = this.getPattern(stack);
        if (pattern == null) {
            return new CalculationResult(CalculationResultType.NO_PATTERN);
        }
        ICraftingTaskFactory factory = API.instance().getCraftingTaskRegistry().get(pattern.getCraftingTaskFactoryId());
        if (factory == null) {
            return new CalculationResult(CalculationResultType.NO_PATTERN);
        }
        return factory.create(this.network, API.instance().createCraftingRequestInfo(stack, quantity), quantity, pattern);
    }

    @Override
    public ICalculationResult create(FluidStack stack, int quantity) {
        ICraftingPattern pattern = this.getPattern(stack);
        if (pattern == null) {
            return new CalculationResult(CalculationResultType.NO_PATTERN);
        }
        ICraftingTaskFactory factory = API.instance().getCraftingTaskRegistry().get(pattern.getCraftingTaskFactoryId());
        if (factory == null) {
            return new CalculationResult(CalculationResultType.NO_PATTERN);
        }
        return factory.create(this.network, API.instance().createCraftingRequestInfo(stack, quantity), quantity, pattern);
    }

    @Override
    public void update() {
        if (this.network.canRun()) {
            if (this.tasksToRead != null) {
                this.readTasks();
            }
            boolean changed = !this.tasksToCancel.isEmpty() || !this.tasksToAdd.isEmpty();
            this.processTasksToCancel();
            this.processTasksToAdd();
            boolean anyFinished = this.updateTasks();
            if (changed || anyFinished) {
                this.onTaskChanged();
            }
            if (!this.tasks.isEmpty()) {
                this.network.markDirty();
            }
        }
    }

    private void processTasksToCancel() {
        for (UUID idToCancel : this.tasksToCancel) {
            if (!this.tasks.containsKey(idToCancel)) continue;
            this.tasks.get(idToCancel).onCancelled();
            this.tasks.remove(idToCancel);
        }
        this.tasksToCancel.clear();
    }

    private void processTasksToAdd() {
        for (ICraftingTask task : this.tasksToAdd) {
            this.tasks.put(task.getId(), task);
        }
        this.tasksToAdd.clear();
    }

    private boolean updateTasks() {
        boolean anyFinished = false;
        Iterator<Map.Entry<UUID, ICraftingTask>> it = this.tasks.entrySet().iterator();
        while (it.hasNext()) {
            ICraftingTask task = it.next().getValue();
            if (!task.update()) continue;
            anyFinished = true;
            it.remove();
        }
        return anyFinished;
    }

    private void readTasks() {
        for (int i = 0; i < this.tasksToRead.size(); ++i) {
            CompoundTag taskTag = this.tasksToRead.m_128728_(i);
            ResourceLocation taskType = new ResourceLocation(taskTag.m_128461_(NBT_TASK_TYPE));
            CompoundTag taskData = taskTag.m_128469_(NBT_TASK_DATA);
            ICraftingTaskFactory factory = API.instance().getCraftingTaskRegistry().get(taskType);
            if (factory == null) continue;
            try {
                ICraftingTask task = factory.createFromNbt(this.network, taskData);
                this.tasks.put(task.getId(), task);
                continue;
            }
            catch (CraftingTaskReadException e) {
                LOGGER.error("Could not deserialize crafting task", (Throwable)e);
            }
        }
        this.tasksToRead = null;
    }

    @Override
    public void readFromNbt(CompoundTag tag) {
        this.tasksToRead = tag.m_128437_(NBT_TASKS, 10);
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag) {
        ListTag list = new ListTag();
        for (ICraftingTask task : this.tasks.values()) {
            CompoundTag taskTag = new CompoundTag();
            taskTag.m_128359_(NBT_TASK_TYPE, task.getPattern().getCraftingTaskFactoryId().toString());
            taskTag.m_128365_(NBT_TASK_DATA, (Tag)task.writeToNbt(new CompoundTag()));
            list.add((Object)taskTag);
        }
        tag.m_128365_(NBT_TASKS, (Tag)list);
        return tag;
    }

    @Override
    public void addListener(ICraftingMonitorListener listener) {
        this.listeners.add(listener);
        listener.onAttached();
    }

    @Override
    public void removeListener(ICraftingMonitorListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void onTaskChanged() {
        this.listeners.forEach(ICraftingMonitorListener::onChanged);
    }

    @Override
    @Nullable
    public ICraftingTask request(Object source, ItemStack stack, int amount) {
        if (this.isThrottled(source)) {
            return null;
        }
        for (ICraftingTask task : this.getTasks()) {
            if (task.getRequested().getItem() == null || !API.instance().getComparer().isEqualNoQuantity(task.getRequested().getItem(), stack)) continue;
            amount -= task.getQuantity();
        }
        if (amount > 0) {
            ICalculationResult result = this.create(stack, amount);
            if (result.isOk()) {
                this.start(result.getTask());
                return result.getTask();
            }
            this.throttle(source);
        }
        return null;
    }

    @Override
    @Nullable
    public ICraftingTask request(Object source, FluidStack stack, int amount) {
        if (this.isThrottled(source)) {
            return null;
        }
        for (ICraftingTask task : this.getTasks()) {
            if (task.getRequested().getFluid() == null || !API.instance().getComparer().isEqual(task.getRequested().getFluid(), stack, 1)) continue;
            amount -= task.getQuantity();
        }
        if (amount > 0) {
            ICalculationResult result = this.create(stack, amount);
            if (result.isOk()) {
                this.start(result.getTask());
                return result.getTask();
            }
            this.throttle(source);
        }
        return null;
    }

    private void throttle(Object source) {
        if (source != null) {
            this.throttledRequesters.put(source, System.currentTimeMillis());
        }
    }

    private boolean isThrottled(Object source) {
        if (source == null) {
            return false;
        }
        Long throttledSince = this.throttledRequesters.get(source);
        if (throttledSince == null) {
            return false;
        }
        return System.currentTimeMillis() - throttledSince < 3000L;
    }

    @Override
    public int track(@Nonnull ItemStack stack, int size) {
        if (stack.m_41619_()) {
            return 0;
        }
        for (ICraftingTask task : this.tasks.values()) {
            size = task.onTrackedInsert(stack, size);
            if (size != 0) continue;
            return 0;
        }
        return size;
    }

    @Override
    public int track(@Nonnull FluidStack stack, int size) {
        if (stack.isEmpty()) {
            return 0;
        }
        for (ICraftingTask task : this.tasks.values()) {
            size = task.onTrackedInsert(stack, size);
            if (size != 0) continue;
            return 0;
        }
        return size;
    }

    @Override
    public List<ICraftingPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public void invalidate() {
        this.network.getItemStorageCache().getCraftablesList().clear();
        this.network.getFluidStorageCache().getCraftablesList().clear();
        this.patterns.clear();
        this.fluidPatternsByOutput.clear();
        this.itemPatternsByOutput.clear();
        this.containerInventories.clear();
        this.patternToContainer.clear();
        List<ICraftingPatternContainer> containers = this.getContainers();
        for (ICraftingPatternContainer container : containers) {
            for (ICraftingPattern pattern : container.getPatterns()) {
                this.patterns.add(pattern);
                for (ItemStack output : pattern.getOutputs()) {
                    this.network.getItemStorageCache().getCraftablesList().add(output);
                    this.itemPatternsByOutput.put(new ItemStackKey(output), pattern);
                }
                for (ItemStack output : pattern.getFluidOutputs()) {
                    this.network.getFluidStorageCache().getCraftablesList().add((FluidStack)output);
                    this.fluidPatternsByOutput.put(new FluidStackKey((FluidStack)output), pattern);
                }
                Set containersForPattern = this.patternToContainer.computeIfAbsent(pattern, key -> new LinkedHashSet());
                containersForPattern.add(container);
            }
            IItemHandlerModifiable handler = container.getPatternInventory();
            if (handler == null) continue;
            this.containerInventories.computeIfAbsent(container.getName(), k -> new ArrayList()).add(handler);
        }
        this.network.getItemStorageCache().reAttachListeners();
        this.network.getFluidStorageCache().reAttachListeners();
    }

    private List<ICraftingPatternContainer> getContainers() {
        ArrayList<ICraftingPatternContainer> containers = new ArrayList<ICraftingPatternContainer>();
        for (INetworkNodeGraphEntry entry : this.network.getNodeGraph().all()) {
            if (!(entry.getNode() instanceof ICraftingPatternContainer) || !entry.getNode().isActive()) continue;
            containers.add((ICraftingPatternContainer)((Object)entry.getNode()));
        }
        containers.sort((a, b) -> b.getPosition().compareTo((Vec3i)a.getPosition()));
        return containers;
    }

    @Override
    public Set<ICraftingPatternContainer> getAllContainers(ICraftingPattern pattern) {
        return this.patternToContainer.getOrDefault(pattern, Collections.emptySet());
    }

    @Override
    @Nullable
    public ICraftingPattern getPattern(ItemStack pattern) {
        return this.itemPatternsByOutput.get(new ItemStackKey(pattern));
    }

    @Override
    @Nullable
    public ICraftingPattern getPattern(FluidStack pattern) {
        return this.fluidPatternsByOutput.get(new FluidStackKey(pattern));
    }

    private static class ItemStackKey {
        private final Item item;
        private final CompoundTag tag;

        public ItemStackKey(ItemStack itemStack) {
            this.item = itemStack.m_41720_();
            this.tag = itemStack.m_41783_();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemStackKey that = (ItemStackKey)o;
            return this.item.equals(that.item) && Objects.equals(this.tag, that.tag);
        }

        public int hashCode() {
            return Objects.hash(this.item, this.tag);
        }
    }

    private static class FluidStackKey {
        private final Fluid fluid;
        private final CompoundTag tag;

        public FluidStackKey(FluidStack fluidStack) {
            this.fluid = fluidStack.getFluid();
            this.tag = fluidStack.getTag();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FluidStackKey that = (FluidStackKey)o;
            return this.fluid.equals(that.fluid) && Objects.equals(this.tag, that.tag);
        }

        public int hashCode() {
            return Objects.hash(this.fluid, this.tag);
        }
    }
}

