/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.FluidTools;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.world.level.block.entity.steamboiler.SteamBoilerBlockEntity;
import mods.railcraft.world.level.block.steamboiler.FireboxBlock;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.level.material.TankManager;
import mods.railcraft.world.level.material.steam.SteamBoiler;
import mods.railcraft.world.module.ContainerModule;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class SteamBoilerModule<T extends SteamBoilerBlockEntity>
extends ContainerModule<T> {
    public static final int TANK_WATER = 0;
    public static final int TANK_STEAM = 1;
    public static final int SLOT_LIQUID_INPUT = 0;
    public static final int SLOT_LIQUID_PROCESSING = 1;
    public static final int SLOT_LIQUID_OUTPUT = 2;
    protected final SteamBoiler boiler;
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.tankManager);
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new InvWrapper(this){

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 2) {
                return ItemStack.f_41583_;
            }
            return super.extractItem(slot, amount, simulate);
        }
    });
    protected final TankManager tankManager = new TankManager(new StandardTank[0]);
    private final StandardTank waterTank = StandardTank.ofBuckets(4).fillProcessor(this::checkFill).filter((Fluid)Fluids.f_76193_);
    private final StandardTank steamTank = StandardTank.ofBuckets(16).filter(RailcraftTags.Fluids.STEAM);
    protected final ContainerMapper fluidContainer = ContainerMapper.make((Container)this.container, 0, 3).ignoreItemChecks();
    private FluidTools.ProcessState waterProcessState = FluidTools.ProcessState.RESET;
    private int processTicks;
    private boolean explode;

    public SteamBoilerModule(T provider, int containerSize) {
        super(provider, containerSize);
        this.waterTank.changeCallback(() -> provider.m_6596_());
        this.steamTank.changeCallback(() -> provider.m_6596_());
        this.tankManager.add(this.waterTank);
        this.tankManager.add(this.steamTank);
        this.waterTank.disableDrain();
        this.steamTank.disableFill();
        this.boiler = new SteamBoiler(this.waterTank, this.steamTank);
        this.boiler.setChangeListener(() -> provider.syncToClient());
    }

    public StandardTank getWaterTank() {
        return this.waterTank;
    }

    public StandardTank getSteamTank() {
        return this.steamTank;
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }

    public LazyOptional<IFluidHandler> getFluidHandler() {
        return this.fluidHandler;
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return this.itemHandler;
    }

    public void update(SteamBoilerBlockEntity.Metadata metadata) {
        int capacity = metadata.tanks() * 1000;
        this.tankManager.setCapacity(1, capacity * metadata.steamCapacityPerTank());
        this.tankManager.setCapacity(0, capacity * 4);
        this.boiler.setMaxTemperature(metadata.maxTemperature());
        this.boiler.setTicksPerCycle(metadata.ticksPerCycle());
    }

    private FluidStack checkFill(FluidStack fluidStack) {
        return this.boiler.checkFill(fluidStack, () -> {
            this.explode = true;
        });
    }

    public SteamBoiler getBoiler() {
        return this.boiler;
    }

    @Override
    public void serverTick() {
        boolean burning = this.boiler.isBurning();
        if (!((SteamBoilerBlockEntity)this.provider).isMaster()) {
            this.boiler.reduceHeat(1);
            burning = ((SteamBoilerBlockEntity)this.provider).getMembership().flatMap(membership -> ((SteamBoilerBlockEntity)membership.master()).getModule(SteamBoilerModule.class)).map(module -> module.getBoiler().isBurning()).orElse(false);
        }
        Level level = ((SteamBoilerBlockEntity)this.provider).m_58904_();
        BlockPos blockPos = ((SteamBoilerBlockEntity)this.provider).m_58899_();
        BlockState blockState = ((SteamBoilerBlockEntity)this.provider).m_58900_();
        if (blockState.m_60734_() instanceof FireboxBlock && burning != (Boolean)blockState.m_61143_(FireboxBlock.LIT)) {
            level.m_46597_(blockPos, (BlockState)blockState.m_61124_(FireboxBlock.LIT, (Comparable)Boolean.valueOf(burning)));
        }
        if (!((SteamBoilerBlockEntity)this.provider).isMaster()) {
            return;
        }
        SteamBoilerBlockEntity.Metadata metadata = (SteamBoilerBlockEntity.Metadata)((SteamBoilerBlockEntity)this.provider).getCurrentPattern().get().getMetadata();
        if (this.explode) {
            level.m_254849_(null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 5.0f + 0.1f * (float)metadata.tanks(), Level.ExplosionInteraction.TNT);
            this.explode = false;
            return;
        }
        this.boiler.tick(metadata.tanks());
        if (this.processTicks++ >= 8) {
            this.processTicks = 0;
            this.processFluidContainers();
        }
    }

    protected void processFluidContainers() {
        this.waterProcessState = FluidTools.processContainer(this.fluidContainer, this.waterTank, FluidTools.ProcessType.DRAIN_ONLY, this.waterProcessState);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("tankManager", (Tag)this.tankManager.serializeNBT());
        tag.m_128365_("boiler", (Tag)this.boiler.serializeNBT());
        tag.m_128359_("processState", this.waterProcessState.m_7912_());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.tankManager.deserializeNBT(tag.m_128437_("tankManager", 10));
        this.boiler.deserializeNBT(tag.m_128469_("boiler"));
        this.waterProcessState = FluidTools.ProcessState.getByName(tag.m_128461_("processState")).orElse(FluidTools.ProcessState.RESET);
    }
}

