/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.level.block.track.outfitted.ReversiblePoweredOutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;

public class ControlTrackBlock
extends ReversiblePoweredOutfittedTrackBlock {
    private static final double BOOST_AMOUNT = 0.02;
    private static final double SLOW_AMOUNT = 0.02;

    public ControlTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    public int getPowerPropagation(BlockState blockState, Level level, BlockPos pos) {
        return 16;
    }

    @Override
    public void onMinecartPass(BlockState blockState, Level level, BlockPos pos, AbstractMinecart cart) {
        Locomotive locomotive;
        RailShape trackShape = ControlTrackBlock.getRailShapeRaw(blockState);
        Vec3 deltaMovement = cart.m_20184_();
        boolean powered = ControlTrackBlock.isPowered(blockState);
        boolean reversed = ControlTrackBlock.isReversed(blockState);
        if (RailShapeUtil.isNorthSouth(trackShape)) {
            if (deltaMovement.m_7094_() <= 0.0) {
                if (ControlTrackBlock.isPowered(blockState) ^ !reversed) {
                    cart.m_20256_(deltaMovement.m_82492_(0.0, 0.0, 0.02));
                } else {
                    cart.m_20256_(deltaMovement.m_82520_(0.0, 0.0, 0.02));
                }
            } else if (deltaMovement.m_7094_() >= 0.0) {
                if (!powered ^ !reversed) {
                    cart.m_20256_(deltaMovement.m_82520_(0.0, 0.0, 0.02));
                } else {
                    cart.m_20256_(deltaMovement.m_82492_(0.0, 0.0, 0.02));
                }
            }
        } else if (deltaMovement.m_7096_() <= 0.0) {
            if (powered ^ reversed) {
                cart.m_20256_(deltaMovement.m_82492_(0.02, 0.0, 0.0));
            } else {
                cart.m_20256_(deltaMovement.m_82520_(0.02, 0.0, 0.0));
            }
        } else if (deltaMovement.m_7096_() >= 0.0) {
            if (!powered ^ reversed) {
                cart.m_20256_(deltaMovement.m_82520_(0.02, 0.0, 0.0));
            } else {
                cart.m_20256_(deltaMovement.m_82492_(0.02, 0.0, 0.0));
            }
        }
        if (cart instanceof Locomotive && (locomotive = (Locomotive)cart).isShutdown()) {
            double yaw = (double)cart.m_146908_() * Math.PI / 180.0;
            double cos = Math.cos(yaw);
            double sin = Math.sin(yaw);
            float limit = 0.01f;
            if (deltaMovement.m_7096_() > (double)limit && cos < 0.0 || deltaMovement.m_7096_() < (double)(-limit) && cos > 0.0 || deltaMovement.m_7094_() > (double)limit && sin < 0.0 || deltaMovement.m_7094_() < (double)(-limit) && sin > 0.0) {
                cart.m_146922_((cart.m_146908_() + 180.0f) % 360.0f);
                cart.f_19859_ = cart.m_146908_();
            }
        }
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.m_237115_((String)Translations.Tips.CONTROL_TRACK).m_130940_(ChatFormatting.GRAY));
        lines.add((Component)Component.m_237115_((String)Translations.Tips.HIT_CROWBAR_TO_CHANGE_DIRECTION).m_130940_(ChatFormatting.BLUE));
        lines.add((Component)Component.m_237115_((String)Translations.Tips.APPLY_REDSTONE_TO_CHANGE_DIRECTION).m_130940_(ChatFormatting.RED));
    }
}

