/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import java.util.List;
import java.util.UUID;
import mods.railcraft.api.track.ArrowDirection;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.track.SwitchTrackBlockEntity;
import mods.railcraft.world.level.block.track.outfitted.SwitchTrackBlock;
import mods.railcraft.world.level.block.track.outfitted.TurnoutTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TurnoutTrackBlockEntity
extends SwitchTrackBlockEntity {
    public TurnoutTrackBlockEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)RailcraftBlockEntityTypes.TURNOUT_TRACK.get(), blockPos, blockState);
    }

    public TurnoutTrackBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    @Override
    public ArrowDirection getRedArrowDirection() {
        boolean switched = SwitchTrackBlock.isSwitched(this.m_58900_());
        Direction facing = SwitchTrackBlock.getFacing(this.m_58900_());
        boolean mirrored = TurnoutTrackBlock.isMirrored(this.m_58900_());
        return ArrowDirection.fromHorizontalDirection(switched ? (mirrored ? facing.m_122428_() : facing.m_122427_()) : (mirrored ? facing.m_122424_() : facing));
    }

    @Override
    public ArrowDirection getWhiteArrowDirection() {
        boolean switched = SwitchTrackBlock.isSwitched(this.m_58900_());
        Direction facing = SwitchTrackBlock.getFacing(this.m_58900_());
        return facing.m_122434_() == Direction.Axis.X ? (switched ? ArrowDirection.EAST_WEST : ArrowDirection.NORTH_SOUTH) : (switched ? ArrowDirection.NORTH_SOUTH : ArrowDirection.EAST_WEST);
    }

    @Override
    protected List<UUID> getCartsAtLockEntrance() {
        return MinecartUtil.getMinecartUUIDsAt(this.f_58857_, this.m_58899_().m_121945_(SwitchTrackBlock.getFacing(this.m_58900_())), 0.1f);
    }

    @Override
    protected List<UUID> getCartsAtDecisionEntrance() {
        return MinecartUtil.getMinecartUUIDsAt(this.f_58857_, this.m_58899_().m_121945_(SwitchTrackBlock.getFacing(this.m_58900_()).m_122424_()), 0.1f);
    }

    @Override
    protected List<UUID> getCartsAtSpringEntrance() {
        Direction facing = SwitchTrackBlock.getFacing(this.m_58900_());
        boolean mirrored = TurnoutTrackBlock.isMirrored(this.m_58900_());
        return MinecartUtil.getMinecartUUIDsAt(this.f_58857_, this.m_58899_().m_121945_(mirrored ? facing.m_122428_() : facing.m_122427_()), 0.1f);
    }

    @Override
    public Direction getActuatorDirection() {
        boolean mirrored = TurnoutTrackBlock.isMirrored(this.m_58900_());
        Direction facing = SwitchTrackBlock.getFacing(this.m_58900_());
        return mirrored ? facing.m_122427_() : facing.m_122428_();
    }
}

