/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.signal;

import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import mods.railcraft.api.core.Lockable;
import mods.railcraft.api.util.EnumUtil;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.gui.button.ButtonState;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBoxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class LockableSignalBoxBlockEntity
extends AbstractSignalBoxBlockEntity
implements Lockable {
    private Lock lock = Lock.UNLOCKED;

    public LockableSignalBoxBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public Lock getLock() {
        return this.lock;
    }

    public void setLock(Lock lock) {
        this.lock = lock;
        this.m_6596_();
    }

    @Override
    public boolean isLocked() {
        return this.lock == Lock.LOCKED;
    }

    @Override
    public boolean canAccess(GameProfile gameProfile) {
        return !this.isLocked() || this.isOwnerOrOperator(gameProfile);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("lock", this.lock.m_7912_());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.lock = Lock.getByName(tag.m_128461_("lock")).orElse(Lock.UNLOCKED);
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        data.m_130068_((Enum)this.lock);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.lock = (Lock)data.m_130066_(Lock.class);
    }

    public static enum Lock implements ButtonState<Lock>,
    StringRepresentable
    {
        UNLOCKED("unlocked", ButtonTexture.UNLOCKED_BUTTON),
        LOCKED("locked", ButtonTexture.LOCKED_BUTTON);

        private static final Map<String, Lock> byName;
        private final String name;
        private final TexturePosition texture;

        private Lock(String name, TexturePosition texture) {
            this.name = name;
            this.texture = texture;
        }

        @Override
        public Component label() {
            return Component.m_237119_();
        }

        @Override
        public TexturePosition texturePosition() {
            return this.texture;
        }

        @Override
        public Lock next() {
            return (Lock)EnumUtil.next((Enum)this, (Enum[])Lock.values());
        }

        public String m_7912_() {
            return this.name;
        }

        public static Optional<Lock> getByName(String name) {
            return Optional.ofNullable(byName.get(name));
        }

        static {
            byName = Arrays.stream(Lock.values()).collect(Collectors.toUnmodifiableMap(Lock::m_7912_, Function.identity()));
        }
    }
}

