/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.manipulator;

import java.util.Optional;
import mods.railcraft.util.FluidTools;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.inventory.FluidManipulatorMenu;
import mods.railcraft.world.level.block.entity.manipulator.ManipulatorBlockEntity;
import mods.railcraft.world.level.material.FluidItemHelper;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.level.material.TankManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public abstract class FluidManipulatorBlockEntity
extends ManipulatorBlockEntity
implements WorldlyContainer,
MenuProvider {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_PROCESSING = 1;
    protected static final int SLOT_OUTPUT = 2;
    protected static final int[] SLOTS = ContainerTools.buildSlotArray(0, 3);
    protected final AdvancedContainer fluidFilterContainer = new AdvancedContainer(1).listener(this).phantom();
    protected final TankManager tankManager = new TankManager(new StandardTank[0]);
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.tankManager);
    protected final StandardTank tank = StandardTank.ofBuckets(32);
    private FluidTools.ProcessState processState = FluidTools.ProcessState.RESET;
    private int fluidProcessingTimer;

    protected FluidManipulatorBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
        this.setContainerSize(3);
        this.tankManager.add(this.tank);
        this.tank.setValidator(fluidStack -> this.getFilterFluid().map(arg_0 -> ((FluidStack)fluidStack).isFluidEqual(arg_0)).orElse(true));
        this.tank.changeCallback(this::tankChanged);
    }

    protected void tankChanged() {
        this.syncToClient();
        this.m_6596_();
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }

    public AdvancedContainer getFluidFilter() {
        return this.fluidFilterContainer;
    }

    public Optional<FluidStack> getFilterFluid() {
        return FluidUtil.getFluidContained((ItemStack)this.fluidFilterContainer.m_8020_(0));
    }

    public FluidStack getFluidHandled() {
        return this.getFilterFluid().orElseGet(() -> ((StandardTank)this.tank).getFluid());
    }

    @Nullable
    protected static IFluidHandler getFluidHandler(AbstractMinecart cart, Direction direction) {
        return (IFluidHandler)cart.getCapability(ForgeCapabilities.FLUID_HANDLER, direction).orElse(null);
    }

    public boolean use(Player player, InteractionHand hand) {
        return FluidTools.interactWithFluidHandler(player, hand, (IFluidHandler)this.tank);
    }

    @Override
    public boolean canHandleCart(AbstractMinecart cart) {
        return cart.getCapability(ForgeCapabilities.FLUID_HANDLER, this.getFacing().m_122424_()).isPresent() && super.canHandleCart(cart);
    }

    @Override
    protected void upkeep() {
        super.upkeep();
        ContainerTools.dropIfInvalid(this.f_58857_, this.m_58899_(), this, 0);
        ContainerTools.drop(this.f_58857_, this.m_58899_(), this, 1, FluidItemHelper::isContainer);
        ContainerTools.drop(this.f_58857_, this.m_58899_(), this, 2, FluidItemHelper::isContainer);
        if (this.fluidProcessingTimer++ >= 8) {
            this.fluidProcessingTimer = 0;
            this.processState = FluidTools.processContainer(this, this.tank, this.getProcessType(), this.processState);
        }
    }

    protected abstract FluidTools.ProcessType getProcessType();

    @Override
    public boolean m_7013_(int slot, ItemStack stack) {
        if (slot == 0) {
            if (!FluidItemHelper.isContainer(stack)) {
                return false;
            }
            if (FluidItemHelper.isEmptyContainer(stack)) {
                return true;
            }
            return this.getFilterFluid().map(FluidStack::getFluid).map(fluid -> FluidItemHelper.containsFluid(stack, fluid)).orElse(true);
        }
        return false;
    }

    public int[] m_7071_(Direction side) {
        return SLOTS;
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index == 2;
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new FluidManipulatorMenu(id, inventory, this);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("processState", this.processState.m_7912_());
        tag.m_128365_("tankManager", (Tag)this.tankManager.serializeNBT());
        tag.m_128365_("invFilter", (Tag)this.getFluidFilter().m_7927_());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.processState = FluidTools.ProcessState.getByName(tag.m_128461_("processState")).orElse(FluidTools.ProcessState.RESET);
        this.tankManager.deserializeNBT(tag.m_128437_("tankManager", 10));
        this.getFluidFilter().m_7797_(tag.m_128437_("invFilter", 10));
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.tankManager.readPacketData(data);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.FLUID_HANDLER ? this.fluidHandler.cast() : super.getCapability(capability, facing);
    }
}

