/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block;

import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.integrations.jei.JeiSearchable;
import mods.railcraft.world.level.block.entity.FeedStationBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class FeedStationBlock
extends BaseEntityBlock
implements JeiSearchable {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    protected FeedStationBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        level.m_141902_(pos, (BlockEntityType)RailcraftBlockEntityTypes.FEED_STATION.get()).ifPresent(blockEntity -> NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)blockEntity, (BlockPos)pos));
        return InteractionResult.CONSUME;
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new FeedStationBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.m_5776_() ? null : FeedStationBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.FEED_STATION.get()), FeedStationBlockEntity::serverTick);
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block neighborBlock, BlockPos neighborPos, boolean moved) {
        if (!level.m_5776_()) {
            Boolean powered = (Boolean)blockState.m_61143_((Property)POWERED);
            boolean neighborSignal = level.m_276867_(blockPos);
            if (powered != neighborSignal) {
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(neighborSignal)), 2);
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof FeedStationBlockEntity) {
            FeedStationBlockEntity feedStation = (FeedStationBlockEntity)blockEntity;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)feedStation);
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)Translations.Tips.FEED_STATION).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)Translations.Tips.APPLY_REDSTONE_TO_DISABLE).m_130940_(ChatFormatting.RED));
    }

    @Override
    public Component addJeiInfo() {
        return Component.m_237115_((String)Translations.Jei.FEED_STATION);
    }
}

