/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.RailcraftBlocks;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;

public class CrusherRecipe
implements Recipe<Container> {
    private final ResourceLocation recipeId;
    private final Ingredient ingredient;
    private final List<Tuple<ItemStack, Double>> probabilityItems;
    private final int processTime;

    public CrusherRecipe(ResourceLocation recipeId, Ingredient ingredient, List<Tuple<ItemStack, Double>> probabilityItems, int processTime) {
        this.recipeId = recipeId;
        this.ingredient = ingredient;
        this.probabilityItems = probabilityItems;
        this.processTime = processTime;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public boolean m_5818_(Container inventory, Level level) {
        return this.ingredient.test(inventory.m_8020_(0));
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess).m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @Deprecated(forRemoval=false)
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public List<Tuple<ItemStack, Double>> getProbabilityItems() {
        return this.probabilityItems;
    }

    public List<ItemStack> pollOutputs(RandomSource random) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Tuple<ItemStack, Double> item : this.probabilityItems) {
            if (!(random.m_188500_() < (Double)item.m_14419_())) continue;
            result.add(((ItemStack)item.m_14418_()).m_41777_());
        }
        return result;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.ingredient});
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RailcraftRecipeSerializers.CRUSHER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RailcraftRecipeTypes.CRUSHING.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)RailcraftBlocks.CRUSHER.get());
    }

    public static class Serializer
    implements RecipeSerializer<CrusherRecipe> {
        public CrusherRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int processTime = GsonHelper.m_13824_((JsonObject)json, (String)"processTime", (int)200);
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            ArrayList<Tuple<ItemStack, Double>> probabilityItems = new ArrayList<Tuple<ItemStack, Double>>();
            JsonArray outputs = GsonHelper.m_13933_((JsonObject)json, (String)"output");
            for (JsonElement output : outputs) {
                JsonObject outputObj = output.getAsJsonObject();
                double probability = GsonHelper.m_144742_((JsonObject)outputObj, (String)"probability", (double)1.0);
                probability = Mth.m_14008_((double)probability, (double)0.0, (double)1.0);
                ItemStack result = Serializer.itemFromJson(GsonHelper.m_13930_((JsonObject)outputObj, (String)"result"));
                probabilityItems.add((Tuple<ItemStack, Double>)new Tuple((Object)result, (Object)probability));
            }
            return new CrusherRecipe(recipeId, ingredient, probabilityItems, processTime);
        }

        public CrusherRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int tickCost = buffer.m_130242_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            List probabilityItems = buffer.m_236845_(buf -> {
                ItemStack result = buf.m_130267_();
                double probability = buf.readDouble();
                return new Tuple((Object)result, (Object)probability);
            });
            return new CrusherRecipe(recipeId, ingredient, probabilityItems, tickCost);
        }

        public void toNetwork(FriendlyByteBuf buffer, CrusherRecipe recipe) {
            buffer.m_130130_(recipe.processTime);
            recipe.ingredient.m_43923_(buffer);
            buffer.m_236828_(recipe.probabilityItems, (buf, item) -> {
                buf.m_130055_((ItemStack)item.m_14418_());
                buf.writeDouble(((Double)item.m_14419_()).doubleValue());
            });
        }

        public static ItemStack itemFromJson(JsonObject json) {
            if (!json.has("item")) {
                throw new JsonParseException("No item key found");
            }
            return CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
        }
    }
}

