/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.advancements.RailcraftCriteriaTriggers;
import mods.railcraft.api.item.SpikeMaulTarget;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.world.level.block.track.TrackBlock;
import mods.railcraft.world.level.block.track.TrackTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.jetbrains.annotations.Nullable;

public class SpikeMaulItem
extends TieredItem {
    private final float attackDamage;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public SpikeMaulItem(float attackDamage, float attackSpeed, Tier tier, Item.Properties properties) {
        super(tier, properties.m_41503_(tier.m_6609_()));
        this.attackDamage = attackDamage + tier.m_6631_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(slot);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        List variants;
        BlockPos blockPos;
        Level level = context.m_43725_();
        BlockState existingBlockState = level.m_8055_(blockPos = context.m_8083_());
        if (!BaseRailBlock.m_49416_((BlockState)existingBlockState)) {
            return InteractionResult.PASS;
        }
        RailShape railShape = TrackBlock.getRailShapeRaw(existingBlockState);
        if (railShape.m_61745_()) {
            return InteractionResult.PASS;
        }
        Block block = existingBlockState.m_60734_();
        if (block instanceof SpikeMaulTarget) {
            SpikeMaulTarget target = (SpikeMaulTarget)block;
            variants = target.getSpikeMaulVariants();
        } else if (existingBlockState.m_60713_(Blocks.f_50156_)) {
            variants = ((TrackType)TrackTypes.IRON.get()).getSpikeMaulVariants();
        } else {
            return InteractionResult.PASS;
        }
        if (variants.isEmpty()) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (player.m_6047_()) {
            variants = Lists.reverse(variants);
        }
        ArrayDeque targets = new ArrayDeque(variants);
        Supplier first = (Supplier)targets.getFirst();
        Supplier found = null;
        do {
            Supplier each;
            if (!existingBlockState.m_60713_((Block)(each = (Supplier)targets.removeFirst()).get())) continue;
            found = targets.isEmpty() ? first : (Supplier)targets.getFirst();
            break;
        } while (!targets.isEmpty());
        if (found == null) {
            return InteractionResult.PASS;
        }
        if (!level.m_46597_(blockPos, ((Block)found.get()).m_5573_(new BlockPlaceContext(context)))) {
            level.m_46597_(blockPos, existingBlockState);
            return InteractionResult.FAIL;
        }
        InteractionHand hand = context.m_43724_();
        ItemStack heldStack = player.m_21120_(hand);
        BlockState newBlockState = level.m_8055_(blockPos);
        SoundType soundtype = newBlockState.getSoundType((LevelReader)level, blockPos, (Entity)player);
        level.m_5594_(player, blockPos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        RailcraftCriteriaTriggers.SPIKE_MAUL_USE.trigger((ServerPlayer)player, heldStack, (ServerLevel)level, blockPos);
        heldStack.m_41622_(1, (LivingEntity)player, __ -> player.m_21190_(hand));
        return InteractionResult.SUCCESS;
    }

    public boolean doesSneakBypassUse(ItemStack itemStack, LevelReader level, BlockPos blockPos, Player player) {
        return true;
    }

    public boolean canDisableShield(ItemStack itemStack, ItemStack shieldStack, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag isAdvanced) {
        components.add((Component)Component.m_237115_((String)Translations.Tips.SPIKE_MAUL).m_130940_(ChatFormatting.GRAY));
    }
}

