/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import mods.railcraft.RailcraftConfig;
import mods.railcraft.Translations;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeBlock;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.charge.ChargeNetworkImpl;
import mods.railcraft.charge.ChargeStorageBlockImpl;
import mods.railcraft.util.HumanReadableNumberFormatter;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ChargeMeterItem
extends Item {
    private static final int SECONDS_TO_RECORD = 5;

    public ChargeMeterItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ChargeBlock chargeBlock;
        ChargeNetworkImpl.ChargeNode node;
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        InteractionResult returnValue = InteractionResult.PASS;
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof ChargeBlock && (node = (ChargeNetworkImpl.ChargeNode)(chargeBlock = (ChargeBlock)block).getMeterAccess(Charge.distribution, state, (ServerLevel)level, pos)) != null && node.isValid() && !node.isGridNull()) {
            ChargeMeterItem.sendChat(player, Translations.ChargeMeter.START, 5);
            node.startUsageRecording(100, avg -> {
                ChargeNetworkImpl.ChargeGrid grid = node.getGrid();
                ChargeMeterItem.sendChat(player, Translations.ChargeMeter.NETWORK, grid.size(), grid.isInfinite() ? "INF" : Integer.valueOf(grid.getCharge()), Float.valueOf(grid.getAverageUsagePerTick()), grid.getMaxDraw(), Float.valueOf(grid.getLosses()), (double)grid.getEfficiency() * 100.0);
                ChargeStorageBlockImpl battery = node.storage().orElse(null);
                if (battery == null) {
                    ChargeMeterItem.sendChat(player, Translations.ChargeMeter.NODE, avg, Float.valueOf(node.getChargeSpec().losses()));
                } else {
                    boolean infiniteBattery = battery.getState() == ChargeStorage.State.INFINITE;
                    ChargeMeterItem.sendChat(player, Translations.ChargeMeter.PRODUCER, infiniteBattery ? "INF" : Integer.valueOf(battery.getAvailableCharge()), infiniteBattery ? "INF" : "NA", battery.getMaxDraw(), (double)node.getChargeSpec().losses() * (Double)RailcraftConfig.SERVER.lossMultiplier.get(), (double)battery.getEfficiency() * 100.0);
                }
            });
            returnValue = InteractionResult.SUCCESS;
        }
        return returnValue;
    }

    public static void sendChat(Player player, String translation, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (!(object instanceof Double)) continue;
            Double doubleArg = (Double)object;
            args[i] = HumanReadableNumberFormatter.format(doubleArg);
        }
        player.m_5661_((Component)Component.m_237110_((String)translation, (Object[])args), false);
    }
}

