/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.inventory.slot;

import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class RailcraftSlot
extends Slot {
    @Nullable
    protected List<Component> tooltip;
    protected boolean phantom;
    protected boolean canAdjustPhantom = true;
    protected boolean canShift = true;
    protected int stackLimit = -1;
    public BooleanSupplier enabled = () -> true;

    public RailcraftSlot(Container container, int index, int x, int y) {
        super(container, index, x, y);
    }

    public boolean m_5857_(ItemStack stack) {
        return this.enabled.getAsBoolean() && this.f_40218_.m_7013_(this.getSlotIndex(), stack);
    }

    public RailcraftSlot setEnableCheck(BooleanSupplier enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    public List<Component> getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(@Nullable List<Component> tooltip) {
        this.tooltip = tooltip;
    }

    public RailcraftSlot setPhantom() {
        this.phantom = true;
        return this;
    }

    public RailcraftSlot blockShift() {
        this.canShift = false;
        return this;
    }

    public RailcraftSlot setCanAdjustPhantom(boolean canAdjust) {
        this.canAdjustPhantom = canAdjust;
        return this;
    }

    public RailcraftSlot setCanShift(boolean canShift) {
        this.canShift = canShift;
        return this;
    }

    public RailcraftSlot setStackLimit(int limit) {
        this.stackLimit = limit;
        return this;
    }

    public final int m_6641_() {
        int max = super.m_6641_();
        return this.stackLimit < 0 ? max : Math.min(max, this.stackLimit);
    }

    public boolean isPhantom() {
        return this.phantom;
    }

    public boolean canAdjustPhantom() {
        return this.canAdjustPhantom;
    }

    public boolean m_8010_(Player player) {
        return !this.isPhantom();
    }

    public boolean canShift() {
        return this.canShift;
    }
}

