/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.inventory;

import mods.railcraft.gui.widget.FluidGaugeWidget;
import mods.railcraft.util.container.StackFilter;
import mods.railcraft.world.entity.vehicle.TankMinecart;
import mods.railcraft.world.inventory.RailcraftMenu;
import mods.railcraft.world.inventory.RailcraftMenuTypes;
import mods.railcraft.world.inventory.slot.FluidFilterSlot;
import mods.railcraft.world.inventory.slot.ItemFilterSlot;
import mods.railcraft.world.inventory.slot.OutputSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;

public class TankMinecartMenu
extends RailcraftMenu {
    private final FluidGaugeWidget fluidGauge;

    public TankMinecartMenu(int id, Inventory inventory, TankMinecart tankMinecart) {
        super((MenuType)RailcraftMenuTypes.TANK_MINECART.get(), id, inventory.f_35978_, arg_0 -> ((TankMinecart)tankMinecart).m_6542_(arg_0));
        this.fluidGauge = new FluidGaugeWidget(tankMinecart.getTankManager(), 35, 23, 176, 0, 16, 47);
        this.addWidget(this.fluidGauge);
        this.m_38897_(new FluidFilterSlot((Container)tankMinecart.getFilterInv(), 0, 80, 21));
        this.m_38897_(new ItemFilterSlot(StackFilter.FLUID_CONTAINER, tankMinecart.getInvLiquids(), 0, 116, 21));
        this.m_38897_(new OutputSlot(tankMinecart.getInvLiquids(), 1, 116, 57));
        this.m_38897_(new OutputSlot(tankMinecart.getInvLiquids(), 2, 80, 57));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 8 + x * 18, 142));
        }
    }

    public FluidGaugeWidget getFluidGauge() {
        return this.fluidGauge;
    }

    public static TankMinecartMenu create(int id, Inventory playerInventory, FriendlyByteBuf data) {
        int entityId = data.m_130242_();
        Entity entity = playerInventory.f_35978_.m_9236_().m_6815_(entityId);
        if (entity instanceof TankMinecart) {
            TankMinecart tankMinecart = (TankMinecart)entity;
            return new TankMinecartMenu(id, playerInventory, tankMinecart);
        }
        throw new IllegalStateException("Cannot find tank minecart with ID: " + entityId);
    }
}

