/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import mods.railcraft.api.item.PrototypedItem;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.world.entity.vehicle.RailcraftMinecart;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class FilteredMinecart
extends RailcraftMinecart {
    private static final EntityDataAccessor<ItemStack> FILTER = SynchedEntityData.m_135353_(FilteredMinecart.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private final AdvancedContainer filterContainer = new AdvancedContainer(1).listener((Container)this).phantom();

    protected FilteredMinecart(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected FilteredMinecart(ItemStack itemStack, EntityType<?> type, double x, double y, double z, Level level) {
        super(type, x, y, z, level);
        this.setFilter(FilteredMinecart.getFilterFromCartItem(itemStack));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FILTER, (Object)ItemStack.f_41583_);
    }

    public static ItemStack getFilterFromCartItem(ItemStack cartStack) {
        return cartStack.m_41720_() instanceof PrototypedItem ? ((PrototypedItem)cartStack.m_41720_()).getPrototype(cartStack) : ItemStack.f_41583_;
    }

    public static ItemStack addFilterToCartItem(ItemStack cartStack, ItemStack filterStack) {
        if (!filterStack.m_41619_() && cartStack.m_41720_() instanceof PrototypedItem) {
            ((PrototypedItem)cartStack.m_41720_()).setPrototype(cartStack, filterStack);
        }
        return cartStack;
    }

    public ItemStack getFilteredCartItem(ItemStack filterStack) {
        ItemStack cartStack = this.m_142340_();
        return cartStack.m_41619_() ? ItemStack.f_41583_ : FilteredMinecart.addFilterToCartItem(cartStack, filterStack);
    }

    public ItemStack m_142340_() {
        ItemStack stack = this.getFilteredCartItem(this.getFilterItem());
        if (!stack.m_41619_() && this.m_8077_()) {
            stack.m_41714_(this.m_5446_());
        }
        return stack;
    }

    @Override
    public boolean canBeRidden() {
        return false;
    }

    @Override
    protected void m_7378_(CompoundTag data) {
        super.m_7378_(data);
        this.filterContainer.m_7797_(data.m_128437_("filter", 10));
        this.f_19804_.m_135381_(FILTER, (Object)this.getFilterInv().m_8020_(0));
    }

    @Override
    protected void m_7380_(CompoundTag data) {
        super.m_7380_(data);
        data.m_128365_("filter", (Tag)this.filterContainer.m_7927_());
    }

    public boolean hasFilter() {
        return !this.getFilterItem().m_41619_();
    }

    public ItemStack getFilterItem() {
        return (ItemStack)this.f_19804_.m_135370_(FILTER);
    }

    public AdvancedContainer getFilterInv() {
        return this.filterContainer;
    }

    public void setFilter(ItemStack filter) {
        this.getFilterInv().m_6836_(0, filter);
    }

    public void m_6596_() {
        super.m_6596_();
        this.f_19804_.m_135381_(FILTER, (Object)this.getFilterInv().m_8020_(0));
    }
}

