/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public final class RayTraceUtil {
    private RayTraceUtil() {
    }

    @Nullable
    public static HitResult rayTrace(BlockPos pos, Vec3 start, Vec3 end, VoxelShape shape) {
        Vec3 vec3d1;
        Vec3 vec3d = start.m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        BlockHitResult raytraceresult = shape.m_83220_(vec3d, vec3d1 = end.m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), pos);
        return raytraceresult == null ? null : new BlockHitResult(raytraceresult.m_82450_().m_82520_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), raytraceresult.m_82434_(), pos, raytraceresult.m_82436_());
    }

    @Nullable
    public static HitResult rayTracePlayerLook(Player player) {
        AABB boundingBox;
        double distance;
        float reachAttribute = (float)player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
        double reachDistance = player.m_7500_() ? (double)reachAttribute : (double)(reachAttribute - 0.5f);
        HitResult hitResult = player.m_19907_(reachDistance, 1.0f, false);
        Vec3 eyePosition = player.m_20299_(1.0f);
        boolean flag = !player.m_7500_() && reachDistance > 3.0;
        double d = distance = player.m_7500_() ? 6.0 : reachDistance;
        if (player.m_7500_()) {
            reachDistance = distance;
        }
        distance *= distance;
        if (hitResult != null) {
            distance = hitResult.m_82450_().m_82557_(eyePosition);
        }
        Vec3 viewVector = player.m_20252_(1.0f);
        Vec3 reachPosition = eyePosition.m_82520_(viewVector.f_82479_ * reachDistance, viewVector.f_82480_ * reachDistance, viewVector.f_82481_ * reachDistance);
        EntityHitResult entityRayTraceResult = ProjectileUtil.m_37287_((Entity)player, (Vec3)eyePosition, (Vec3)reachPosition, (AABB)(boundingBox = player.m_20191_().m_82369_(viewVector.m_82490_(reachDistance)).m_82377_(1.0, 1.0, 1.0)), entity -> !entity.m_5833_() && entity.m_6087_(), (double)distance);
        if (entityRayTraceResult != null) {
            Vec3 entityHitLocation = entityRayTraceResult.m_82450_();
            double entityHitDistance = eyePosition.m_82557_(entityHitLocation);
            if (flag && entityHitDistance > 9.0) {
                return BlockHitResult.m_82426_((Vec3)entityHitLocation, (Direction)Direction.m_122366_((double)viewVector.f_82479_, (double)viewVector.f_82480_, (double)viewVector.f_82481_), (BlockPos)BlockPos.m_274446_((Position)entityHitLocation));
            }
            if (entityHitDistance < distance || hitResult == null) {
                return entityRayTraceResult;
            }
        }
        return hitResult;
    }

    @Nullable
    public static Direction getCurrentMousedOverSide(Player player) {
        HitResult hitResult = RayTraceUtil.rayTracePlayerLook(player);
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            return blockHitResult.m_82434_();
        }
        return null;
    }
}

