/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class FunctionalUtil {
    public static IntStream rangeClosed(int startInclusive, int endInclusive) {
        return startInclusive <= endInclusive ? IntStream.rangeClosed(startInclusive, endInclusive) : IntStream.rangeClosed(endInclusive, startInclusive).map(i -> endInclusive - i + startInclusive);
    }

    public static <T, U> Function<T, Stream<U>> ofType(Class<U> clazz) {
        return t -> clazz.isInstance(t) ? Stream.of(clazz.cast(t)) : Stream.empty();
    }

    public static <T1, T2 extends T1> T1 get(Optional<T2> obj, T1 orElse) {
        return (T1)(obj.isPresent() ? obj.get() : orElse);
    }

    public static <T, U> Function<T, @Nullable U> ofTypeOrNull(Class<U> clazz) {
        return t -> clazz.isInstance(t) ? clazz.cast(t) : null;
    }

    public static <T> boolean notEqualOrEmpty(Optional<T> opt1, Optional<T> opt2) {
        return opt1.isPresent() && opt2.isPresent() && !opt1.equals(opt2);
    }
}

