/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mods.railcraft.Railcraft;
import mods.railcraft.client.renderer.entity.cart.CustomMinecartRenderer;
import mods.railcraft.season.Seasons;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.AbstractMinecart;

public abstract class StandardMinecartRenderer<T extends AbstractMinecart>
extends CustomMinecartRenderer<T> {
    public static final ResourceLocation SNOW_TEXTURE_LOCATION = Railcraft.rl("textures/carts/cart_snow.png");
    public static final ResourceLocation MINECART_TEXTURE_LOCATION = new ResourceLocation("textures/entity/minecart.png");

    public StandardMinecartRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderBody(T cart, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        EntityModel<T> bodyModel = this.getBodyModel(cart);
        VertexConsumer bodyVertexConsumer = bufferSource.m_6299_(bodyModel.m_103119_(this.getTextureLocation(cart)));
        bodyModel.m_6973_(cart, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        bodyModel.m_7695_(poseStack, bodyVertexConsumer, packedLight, OverlayTexture.f_118083_, red, green, blue, alpha);
        if (Seasons.isPolarExpress(cart)) {
            EntityModel<T> snowModel = this.getSnowModel(cart);
            VertexConsumer snowVertexConsumer = bufferSource.m_6299_(snowModel.m_103119_(SNOW_TEXTURE_LOCATION));
            snowModel.m_6973_(cart, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
            snowModel.m_7695_(poseStack, snowVertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(T cart) {
        return MINECART_TEXTURE_LOCATION;
    }

    protected abstract EntityModel<? super T> getBodyModel(T var1);

    protected abstract EntityModel<? super T> getSnowModel(T var1);
}

