/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import mods.railcraft.client.util.RenderUtil;
import mods.railcraft.network.play.LinkedCartsMessage;
import mods.railcraft.world.item.GogglesItem;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ShuntingAuraRenderer {
    private Collection<LinkedCartsMessage.LinkedCart> linkedCarts;

    public void clearCarts() {
        this.linkedCarts = null;
    }

    public void setLinkedCarts(Collection<LinkedCartsMessage.LinkedCart> linkedCarts) {
        this.linkedCarts = linkedCarts;
    }

    public void render(PoseStack poseStack, Camera mainCamera, float partialTick) {
        GogglesItem.Aura aura;
        if (this.linkedCarts == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack goggles = player.m_6844_(EquipmentSlot.HEAD);
        if (goggles.m_150930_((Item)RailcraftItems.GOGGLES.get()) && (aura = GogglesItem.getAura(goggles)) == GogglesItem.Aura.SHUNTING) {
            poseStack.m_85836_();
            Vec3 projectedView = mainCamera.m_90583_();
            poseStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
            for (LinkedCartsMessage.LinkedCart linkedCart : this.linkedCarts) {
                Entity entity = player.m_9236_().m_6815_(linkedCart.entityId());
                if (!(entity instanceof AbstractMinecart)) continue;
                AbstractMinecart cart = (AbstractMinecart)entity;
                if (linkedCart.trainId() == null) continue;
                VertexConsumer consumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
                PoseStack.Pose pose = poseStack.m_85850_();
                int color = linkedCart.trainId().hashCode();
                float red = RenderUtil.getRed(color);
                float green = RenderUtil.getGreen(color);
                float blue = RenderUtil.getBlue(color);
                Vec3 cartPosition = cart.m_20318_(partialTick);
                float cartX = (float)cartPosition.m_7096_();
                float cartY = (float)cartPosition.m_7098_();
                float cartZ = (float)cartPosition.m_7094_();
                consumer.m_252986_(pose.m_252922_(), cartX, cartY, cartZ).m_85950_(red, green, blue, 1.0f).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 0.0f).m_5752_();
                consumer.m_252986_(pose.m_252922_(), cartX, cartY + 2.0f, cartZ).m_85950_(red, green, blue, 1.0f).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 0.0f).m_5752_();
                this.renderLink(player.m_9236_(), cartX, cartY, cartZ, linkedCart.linkAId(), red, green, blue, partialTick, consumer, pose);
                this.renderLink(player.m_9236_(), cartX, cartY, cartZ, linkedCart.linkBId(), red, green, blue, partialTick, consumer, pose);
                Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
            }
            poseStack.m_85849_();
        }
    }

    private void renderLink(Level level, float cartX, float cartY, float cartZ, int cartId, float red, float green, float blue, float partialTick, VertexConsumer consumer, PoseStack.Pose pose) {
        if (cartId == -1) {
            return;
        }
        Entity cartA = level.m_6815_(cartId);
        if (cartA == null) {
            return;
        }
        Vec3 cartAPosition = cartA.m_20318_(partialTick);
        consumer.m_252986_(pose.m_252922_(), cartX, cartY + 2.0f, cartZ).m_85950_(red, green, blue, 1.0f).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose.m_252922_(), (float)cartAPosition.m_7096_(), (float)cartAPosition.m_7098_() + 1.5f, (float)cartAPosition.m_7094_()).m_85950_(red, green, blue, 1.0f).m_252939_(pose.m_252943_(), 0.0f, 0.0f, 0.0f).m_5752_();
    }
}

