/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory;

import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.client.gui.screen.inventory.RailcraftMenuScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.MultiButton;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.SetMaintenanceMinecartAttributesMessage;
import mods.railcraft.world.entity.vehicle.MaintenanceMinecart;
import mods.railcraft.world.entity.vehicle.MaintenancePatternMinecart;
import mods.railcraft.world.inventory.RailcraftMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public abstract class MaintenanceMinecartScreen<T extends RailcraftMenu>
extends RailcraftMenuScreen<T> {
    protected static final Component PATTERN = Component.m_237115_((String)Translations.Screen.PATTERN);
    protected static final Component STOCK = Component.m_237115_((String)Translations.Screen.STOCK);
    private static final int REFRESH_INTERVAL_TICKS = 20;
    private final MaintenancePatternMinecart cart;
    private MultiButton<MaintenanceMinecart.Mode> mode;
    private int refreshTimer;

    protected MaintenanceMinecartScreen(T menu, Inventory inventory, Component title, MaintenancePatternMinecart cart) {
        super(menu, inventory, title);
        this.cart = cart;
    }

    protected void m_7856_() {
        super.m_7856_();
        int centreX = (this.f_96543_ - this.getXSize()) / 2;
        int centreY = (this.f_96544_ - this.getYSize()) / 2;
        this.mode = (MultiButton)this.m_142416_((GuiEventListener)((MultiButton)((MultiButton.Builder)MultiButton.builder(ButtonTexture.SMALL_BUTTON, this.cart.mode()).bounds(centreX + 120, centreY + this.getYSize() - 100, 40, 16)).stateCallback(this::setMaintenanceMode).tooltipFactory(this::createLockTooltip).build()));
        this.updateButtons();
    }

    private Optional<Tooltip> createLockTooltip(MaintenanceMinecart.Mode mode) {
        return Optional.of(Tooltip.m_257550_((Component)Component.m_237115_((String)mode.getTipsKey())));
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.refreshTimer++ >= 20) {
            this.updateButtons();
        }
    }

    private void setMaintenanceMode(MaintenanceMinecart.Mode mode) {
        if (mode != this.cart.mode()) {
            this.cart.setMode(mode);
            this.updateButtons();
            NetworkChannel.GAME.sendToServer(new SetMaintenanceMinecartAttributesMessage(this.cart.m_19879_(), mode));
        }
    }

    private void updateButtons() {
        this.mode.setState(this.cart.mode());
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280614_(this.f_96547_, PATTERN, 38, 30, -12566464, false);
        guiGraphics.m_280614_(this.f_96547_, STOCK, 125, 25, -12566464, false);
    }
}

