/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signal;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import mods.railcraft.api.signal.SignalAspect;
import net.minecraft.core.BlockPos;

public interface SignalNetwork<T> {
    public SignalAspect aspect();

    public boolean isLinking();

    public void startLinking();

    public void stopLinking();

    public Optional<T> peerAt(BlockPos var1);

    public Collection<BlockPos> peers();

    default public Stream<T> stream() {
        return this.peers().stream().map(this::peerAt).flatMap(optional -> optional.isPresent() ? Stream.of(optional.get()) : Stream.empty());
    }

    default public int peerCount() {
        return this.peers().size();
    }

    default public boolean hasPeers() {
        return this.peerCount() > 0;
    }

    default public boolean isPeer(BlockPos blockPos) {
        return this.peers().contains(blockPos);
    }

    public boolean addPeer(T var1);

    public boolean removePeer(BlockPos var1);

    public void refresh();

    public void destroy();
}

