/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft;

import java.util.List;
import java.util.stream.IntStream;

public class Translations {
    public static String makeKey(String type, String name) {
        return type + ".railcraft." + name;
    }

    public static class EnchantmentDescriptions {
        public static final String DESTRUCTION = Translations.makeKey("enchantment", "destruction.desc");
        public static final String IMPLOSION = Translations.makeKey("enchantment", "implosion.desc");
        public static final String SMACK = Translations.makeKey("enchantment", "smack.desc");
        public static final String WRECKING = Translations.makeKey("enchantment", "wrecking.desc");
    }

    public static class KeyBinding {
        public static final String CATEGORY = Translations.makeKey("key", "category");
        public static final String CHANGE_AURA = Translations.makeKey("key", "change_aura");
    }

    public static class ChargeMeter {
        public static final String START = Translations.makeKey("charge_meter", "start");
        public static final String CART = Translations.makeKey("charge_meter", "cart");
        public static final String NETWORK = Translations.makeKey("charge_meter", "network");
        public static final String NODE = Translations.makeKey("charge_meter", "node");
        public static final String PRODUCER = Translations.makeKey("charge_meter", "producer");
    }

    public static class RoutingTable {
        public static final List<String> MANUAL_PAGES = IntStream.rangeClosed(1, 12).mapToObj(i -> Translations.makeKey("manual", "routing_table.page." + i)).toList();
        public static final String ERROR_BLANK = Translations.makeKey("error.routing", "blank");
        public static final String ERROR_INVALID_CONSTANT = Translations.makeKey("error.routing", "invalid_constant");
        public static final String ERROR_MALFORMED_SYNTAX = Translations.makeKey("error.routing", "malformed_syntax");
        public static final String ERROR_INSUFFICIENT_OPERAND = Translations.makeKey("error.routing", "insufficient_operand");
        public static final String ERROR_INVALID_OPERAND = Translations.makeKey("error.routing", "invalid_operand");
        public static final String ERROR_INVALID_REGEX = Translations.makeKey("error.routing", "invalid_regex");
        public static final String ERROR_UNSUPPORTED_REGEX = Translations.makeKey("error.routing", "unsupported_regex");
        public static final String UNRECOGNIZED_KEYWORD = Translations.makeKey("error.routing", "unrecognized_keyword");
    }

    public static class DamageSource {
        public static final List<String> BORE = IntStream.rangeClosed(1, 6).mapToObj(i -> Translations.makeKey("death", "bore." + i)).toList();
        public static final List<String> CRUSHER = IntStream.rangeClosed(1, 8).mapToObj(i -> Translations.makeKey("death", "crusher." + i)).toList();
        public static final List<String> ELECTRIC = IntStream.rangeClosed(1, 6).mapToObj(i -> Translations.makeKey("death", "electric." + i)).toList();
        public static final List<String> STEAM = IntStream.rangeClosed(1, 6).mapToObj(i -> Translations.makeKey("death", "steam." + i)).toList();
        public static final List<String> TRACK_ELECTRIC = IntStream.rangeClosed(1, 6).mapToObj(i -> Translations.makeKey("death", "track_electric." + i)).toList();
        public static final List<String> TRAIN = IntStream.rangeClosed(1, 6).mapToObj(i -> Translations.makeKey("death", "train." + i)).toList();
    }

    public static class Subtitle {
        public static final String STEAM_WHISTLE = Translations.makeKey("subtitle", "locomotive.steam.whistle");
        public static final String ELECTRIC_WHISTLE = Translations.makeKey("subtitle", "locomotive.electric.whistle");
        public static final String STEAM_BURST = Translations.makeKey("subtitle", "machine.steam.burst");
        public static final String STEAM_HISS = Translations.makeKey("subtitle", "machine.steam.hiss");
        public static final String MACHINE_ZAP = Translations.makeKey("subtitle", "machine.zap");
    }

    public static class Advancement {

        public static class Carts {
            public static final String ROOT = Translations.makeKey("advancements", "carts.root.name");
            public static final String ROOT_DESC = Translations.makeKey("advancements", "carts.root.desc");
            public static final String BED_CART = Translations.makeKey("advancements", "carts.bed_cart.name");
            public static final String BED_CART_DESC = Translations.makeKey("advancements", "carts.bed_cart.desc");
            public static final String JUKEBOX_CART = Translations.makeKey("advancements", "carts.jukebox_cart.name");
            public static final String JUKEBOX_CART_DESC = Translations.makeKey("advancements", "carts.jukebox_cart.desc");
            public static final String LINK_CARTS = Translations.makeKey("advancements", "carts.link_carts.name");
            public static final String LINK_CARTS_DESC = Translations.makeKey("advancements", "carts.link_carts.desc");
            public static final String LOCOMOTIVE = Translations.makeKey("advancements", "carts.locomotive.name");
            public static final String LOCOMOTIVE_DESC = Translations.makeKey("advancements", "carts.locomotive.desc");
            public static final String SEASONS = Translations.makeKey("advancements", "carts.seasons.name");
            public static final String SEASONS_DESC = Translations.makeKey("advancements", "carts.seasons.desc");
            public static final String SURPRISE = Translations.makeKey("advancements", "carts.surprise.name");
            public static final String SURPRISE_DESC = Translations.makeKey("advancements", "carts.surprise.desc");
        }

        public static class Tracks {
            public static final String ROOT = Translations.makeKey("advancements", "tracks.root.name");
            public static final String ROOT_DESC = Translations.makeKey("advancements", "tracks.root.desc");
            public static final String MANUAL_ROLLING_MACHINE = Translations.makeKey("advancements", "tracks.manual_rolling_machine.name");
            public static final String MANUAL_ROLLING_MACHINE_DESC = Translations.makeKey("advancements", "tracks.manual_rolling_machine.desc");
            public static final String BLAST_FURNACE = Translations.makeKey("advancements", "tracks.blast_furnace.name");
            public static final String BLAST_FURNACE_DESC = Translations.makeKey("advancements", "tracks.blast_furnace.desc");
            public static final String COKE_OVEN = Translations.makeKey("advancements", "tracks.coke_oven.name");
            public static final String COKE_OVEN_DESC = Translations.makeKey("advancements", "tracks.coke_oven.desc");
            public static final String FIRESTONE = Translations.makeKey("advancements", "tracks.firestone.name");
            public static final String FIRESTONE_DESC = Translations.makeKey("advancements", "tracks.firestone.desc");
            public static final String HIGH_SPEED_TRACK = Translations.makeKey("advancements", "tracks.high_speed_track.name");
            public static final String HIGH_SPEED_TRACK_DESC = Translations.makeKey("advancements", "tracks.high_speed_track.desc");
            public static final String JUNCTIONS = Translations.makeKey("advancements", "tracks.junctions.name");
            public static final String JUNCTIONS_DESC = Translations.makeKey("advancements", "tracks.junctions.desc");
            public static final String REGULAR_TRACK = Translations.makeKey("advancements", "tracks.regular_track.name");
            public static final String REGULAR_TRACK_DESC = Translations.makeKey("advancements", "tracks.regular_track.desc");
            public static final String CRUSHER = Translations.makeKey("advancements", "tracks.crusher.name");
            public static final String CRUSHER_DESC = Translations.makeKey("advancements", "tracks.crusher.desc");
            public static final String TRACK_KIT = Translations.makeKey("advancements", "tracks.track_kit.name");
            public static final String TRACK_KIT_DESC = Translations.makeKey("advancements", "tracks.track_kit.desc");
            public static final String WOODEN_TRACK = Translations.makeKey("advancements", "tracks.wooden_track.name");
            public static final String WOODEN_TRACK_DESC = Translations.makeKey("advancements", "tracks.wooden_track.desc");
        }
    }

    public static class SignalCapacitor {
        public static final String RISING_EDGE = Translations.makeKey("signal", "capacitor.rising_edge");
        public static final String RISING_EDGE_DESC = Translations.makeKey("signal", "capacitor.rising_edge.desc");
        public static final String FALLING_EDGE = Translations.makeKey("signal", "capacitor.falling_edge");
        public static final String FALLING_EDGE_DESC = Translations.makeKey("signal", "capacitor.falling_edge.desc");
    }

    public static class SignalAspect {
        public static final String GREEN = Translations.makeKey("signal", "aspect.green");
        public static final String YELLOW = Translations.makeKey("signal", "aspect.yellow");
        public static final String RED = Translations.makeKey("signal", "aspect.red");
        public static final String BLINK_YELLOW = Translations.makeKey("signal", "aspect.blink_yellow");
        public static final String BLINK_RED = Translations.makeKey("signal", "aspect.blink_red");
        public static final String OFF = Translations.makeKey("signal", "aspect.off");
    }

    public static class Signal {
        public static final String SIGNAL_SURVEYOR_INVALID_TRACK = Translations.makeKey("signal", "surveyor.invalid_track");
        public static final String SIGNAL_SURVEYOR_BEGIN = Translations.makeKey("signal", "surveyor.begin");
        public static final String SIGNAL_SURVEYOR_SUCCESS = Translations.makeKey("signal", "surveyor.success");
        public static final String SIGNAL_SURVEYOR_INVALID_PAIR = Translations.makeKey("signal", "surveyor.invalid_pair");
        public static final String SIGNAL_SURVEYOR_LOST = Translations.makeKey("signal", "surveyor.lost");
        public static final String SIGNAL_SURVEYOR_ABANDONED = Translations.makeKey("signal", "surveyor.abandoned");
        public static final String SIGNAL_SURVEYOR_INVALID_BLOCK = Translations.makeKey("signal", "surveyor.invalid_block");
        public static final String SIGNAL_TUNER_BEGIN = Translations.makeKey("signal", "tuner.begin");
        public static final String SIGNAL_TUNER_ABANDONED = Translations.makeKey("signal", "tuner.abandoned");
        public static final String SIGNAL_TUNER_INVALID_CONTROLLER = Translations.makeKey("signal", "tuner.invalid_controller");
        public static final String SIGNAL_TUNER_INVALID_RECEIVER = Translations.makeKey("signal", "tuner.invalid_receiver");
        public static final String SIGNAL_TUNER_ALREADY_PAIRED = Translations.makeKey("signal", "tuner.already_paired");
        public static final String SIGNAL_TUNER_LOST = Translations.makeKey("signal", "tuner.lost");
        public static final String SIGNAL_TUNER_SUCCESS = Translations.makeKey("signal", "tuner.success");
    }

    public static class Jei {
        public static final String METAL_ROLLING = Translations.makeKey("jei", "category.rolling");
        public static final String COKE_OVEN = Translations.makeKey("jei", "category.coke_oven");
        public static final String BLAST_FURNACE = Translations.makeKey("jei", "category.blast_furnace");
        public static final String CRUSHER = Translations.makeKey("jei", "category.crusher");
        public static final String CRUSHER_TIP = Translations.makeKey("jei", "tips.crusher");
        public static final String MANUAL_ROLLING_MACHINE = Translations.makeKey("jei", "desc.manual_rolling_machine");
        public static final String POWERED_ROLLING_MACHINE = Translations.makeKey("jei", "desc.powered_rolling_machine");
        public static final String FEED_STATION = Translations.makeKey("jei", "desc.feed_station");
        public static final String LOGBOOK = Translations.makeKey("jei", "desc.logbook");
        public static final String BLOCK_SIGNAL = Translations.makeKey("jei", "desc.block_signal");
        public static final String DISTANT_SIGNAL = Translations.makeKey("jei", "desc.distant_signal");
        public static final String TOKEN_SIGNAL = Translations.makeKey("jei", "desc.token_signal");
        public static final String DUAL_BLOCK_SIGNAL = Translations.makeKey("jei", "desc.dual_block_signal");
        public static final String DUAL_DISTANT_SIGNAL = Translations.makeKey("jei", "desc.dual_distant_signal");
        public static final String DUAL_TOKEN_SIGNAL = Translations.makeKey("jei", "desc.dual_token_signal");
        public static final String TUNNEL_BORE = Translations.makeKey("jei", "desc.tunnel_bore");
        public static final String NICKEL_IRON_BATTERY = Translations.makeKey("jei", "desc.nickel_iron_battery");
        public static final String NICKEL_ZINC_BATTERY = Translations.makeKey("jei", "desc.nickel_zinc_battery");
        public static final String DISPOSABLE_BATTERY = Translations.makeKey("jei", "desc.disposable_battery");
        public static final String DISPOSABLE_BATTERY_EMPTY = Translations.makeKey("jei", "desc.disposable_battery_empty");
        public static final String PAINT = Translations.makeKey("jei.gui", "paint");
        public static final String COPY_TAG = Translations.makeKey("jei.gui", "copy_tag");
        public static final String REPAIR = Translations.makeKey("jei.gui", "repair");
        public static final String SPLIT = Translations.makeKey("jei.gui", "split");
    }

    public static class Container {
        public static final String COKE_OVEN = Translations.makeKey("container", "coke_oven");
        public static final String BLAST_FURNACE = Translations.makeKey("container", "blast_furnace");
        public static final String CRUSHER = Translations.makeKey("container", "crusher");
        public static final String STEAM_OVEN = Translations.makeKey("container", "steam_oven");
        public static final String WATER_TANK_SIDING = Translations.makeKey("container", "water_tank_siding");
        public static final String TANK = Translations.makeKey("container", "tank");
        public static final String STEAM_TURBINE = Translations.makeKey("container", "steam_turbine");
        public static final String SOLID_FUELED_STEAM_BOILER = Translations.makeKey("container", "solid_fueled_steam_boiler");
        public static final String FLUID_FUELED_STEAM_BOILER = Translations.makeKey("container", "fluid_fueled_steam_boiler");
    }

    public static class Tips {
        public static final String ROUTING_TICKET_ISSUER = Translations.makeKey("tips", "routing.ticket.issuer");
        public static final String ROUTING_TICKET_DEST = Translations.makeKey("tips", "routing.ticket.dest");
        public static final String ROUTING_TICKET_BLANK = Translations.makeKey("tips", "routing.ticket.blank");
        public static final String ROUTING_TABLE_BOOK_LAST_EDIT = Translations.makeKey("tips", "routing.routing_table_book.last_edit");
        public static final String LOCOMOTIVE_SLOT_TICKET = Translations.makeKey("tips", "locomotive.slot.ticket");
        public static final String LOCOMOTIVE_ITEM_OWNER = Translations.makeKey("tips", "locomotive.item.owner");
        public static final String LOCOMOTIVE_ITEM_PRIMARY = Translations.makeKey("tips", "locomotive.item.primary");
        public static final String LOCOMOTIVE_ITEM_SECONDARY = Translations.makeKey("tips", "locomotive.item.secondary");
        public static final String LOCOMOTIVE_ITEM_WHISTLE = Translations.makeKey("tips", "locomotive.item.whistle");
        public static final String TRACK_LAYER = Translations.makeKey("tips", "track_layer");
        public static final String TRACK_RELAYER = Translations.makeKey("tips", "track_relayer");
        public static final String TRACK_REMOVER = Translations.makeKey("tips", "track_remover");
        public static final String TRACK_UNDERCUTTER = Translations.makeKey("tips", "track_undercutter");
        public static final String CRUSHED_OBSIDIAN = Translations.makeKey("tips", "crushed_obsidian");
        public static final String COKE_OVEN = Translations.makeKey("tips", "coke_oven");
        public static final String BLAST_FURNACE = Translations.makeKey("tips", "blast_furnace");
        public static final String CRUSHER = Translations.makeKey("tips", "crusher");
        public static final String WATER_TANK_SIDING = Translations.makeKey("tips", "water_tank_siding");
        public static final String MULTIBLOCK2X2X2 = Translations.makeKey("tips", "multiblock2x2x2");
        public static final String MULTIBLOCK3X2X2 = Translations.makeKey("tips", "multiblock3x2x2");
        public static final String STEAM_TURBINE_DESC_1 = Translations.makeKey("tips", "steam_turbine_desc1");
        public static final String STEAM_TURBINE_DESC_2 = Translations.makeKey("tips", "steam_turbine_desc2");
        public static final String STEAM_TURBINE_DESC_3 = Translations.makeKey("tips", "steam_turbine_desc3");
        public static final String SPIKE_MAUL = Translations.makeKey("tips", "spike_maul");
        public static final String OVERALLS = Translations.makeKey("tips", "overalls");
        public static final String CLEAR = Translations.makeKey("tips", "clear");
        public static final String GOOGLES_DESC = Translations.makeKey("tips", "googles.desc");
        public static final String GOOGLES_AURA = Translations.makeKey("tips", "googles.aura");
        public static final String GOOGLES_AURA_NONE = Translations.makeKey("tips", "googles.aura.none");
        public static final String GOOGLES_AURA_SHUNTING = Translations.makeKey("tips", "googles.aura.shunting");
        public static final String GOOGLES_AURA_SIGNALLING = Translations.makeKey("tips", "googles.aura.signalling");
        public static final String GOOGLES_AURA_SURVEYING = Translations.makeKey("tips", "googles.aura.surveying");
        public static final String GOOGLES_AURA_TRACKING = Translations.makeKey("tips", "googles.aura.tracking");
        public static final String GOOGLES_AURA_TUNING = Translations.makeKey("tips", "googles.aura.tuning");
        public static final String GOOGLES_AURA_WORLDSPIKE = Translations.makeKey("tips", "googles.aura.worldspike");
        public static final String CROWBAR_DESC = Translations.makeKey("tips", "crowbar.desc");
        public static final String CROWBAR_LINK_BROKEN = Translations.makeKey("tips", "crowbar.link.broken");
        public static final String CROWBAR_LINK_CREATED = Translations.makeKey("tips", "crowbar.link.created");
        public static final String CROWBAR_LINK_FAILED = Translations.makeKey("tips", "crowbar.link.failed");
        public static final String CROWBAR_LINK_STARTED = Translations.makeKey("tips", "crowbar.link.started");
        public static final String CROWBAR_SEASON_DESC = Translations.makeKey("tips", "crowbar.season.desc");
        public static final String SIGNAL_LABEL_DESC1 = Translations.makeKey("tips", "signal_label.desc1");
        public static final String SIGNAL_LABEL_DESC2 = Translations.makeKey("tips", "signal_label.desc2");
        public static final String SENDS_SIGNALS_TO_RECEIVERS = Translations.makeKey("tips", "send_signals_to_receivers");
        public static final String SIGNAL_RECEIVER_BOX = Translations.makeKey("tips", "signal_receiver_box");
        public static final String SIGNAL_SEQUENCER_BOX = Translations.makeKey("tips", "signal_sequencer_box");
        public static final String SIGNAL_INTERLOCK_BOX = Translations.makeKey("tips", "signal_interlock_box");
        public static final String SIGNAL_BLOCK_RELAY_BOX = Translations.makeKey("tips", "signal_block_relay_box");
        public static final String FIRESTONE_EMPTY = Translations.makeKey("tips", "firestone.empty");
        public static final String FIRESTONE_CHARGED = Translations.makeKey("tips", "firestone.charged");
        public static final String RAW_FIRESTONE = Translations.makeKey("tips", "firestone.raw");
        public static final String CUT_FIRESTONE = Translations.makeKey("tips", "firestone.cut");
        public static final String FIRESTONE_ORE = Translations.makeKey("tips", "firestone.ore");
        public static final String CURRENT_MODE = Translations.makeKey("tips", "current_mode");
        public static final String TRACK_KIT_CORNERS_UNSUPPORTED = Translations.makeKey("tips", "track_kit.corners_unsupported");
        public static final String TRACK_KIT_SLOPES_UNSUPPORTED = Translations.makeKey("tips", "track_kit.slopes_unsupported");
        public static final String TRACK_KIT_INVALID_TRACK_TYPE = Translations.makeKey("tips", "track_kit.invalid_track_type");
        public static final String COAL_COKE_BLOCK = Translations.makeKey("tips", "coal_coke_block");
        public static final String FORCE_TRACK_EMITTER = Translations.makeKey("tips", "force_track_emitter");
        public static final String FEED_STATION = Translations.makeKey("tips", "feed_station");
        public static final String LOGBOOK = Translations.makeKey("tips", "logbook");
        public static final String ROLLING_MACHINE = Translations.makeKey("tips", "rolling_machine");
        public static final String ITEM_LOADER = Translations.makeKey("tips", "item_loader");
        public static final String ITEM_UNLOADER = Translations.makeKey("tips", "item_unloader");
        public static final String FLUID_LOADER = Translations.makeKey("tips", "fluid_loader");
        public static final String FLUID_UNLOADER = Translations.makeKey("tips", "fluid_unloader");
        public static final String CART_DISPENSER = Translations.makeKey("tips", "cart_dispenser");
        public static final String TRAIN_DISPENSER = Translations.makeKey("tips", "train_dispenser");
        public static final String BLOCK_SIGNAL = Translations.makeKey("tips", "block_signal");
        public static final String DISTANT_SIGNAL = Translations.makeKey("tips", "distant_signal");
        public static final String TOKEN_SIGNAL = Translations.makeKey("tips", "token_signal");
        public static final String SIGNAL_BLOCKS = Translations.makeKey("tips", "signal_blocks");
        public static final String CONTROLLERS = Translations.makeKey("tips", "controllers");
        public static final String SIGNAL_SURVEYOR = Translations.makeKey("tips", "signal_surveyor");
        public static final String TOKEN_AREA = Translations.makeKey("tips", "token_area");
        public static final String FRAME = Translations.makeKey("tips", "frame");
        public static final String SIGNAL_BLOCK_SURVEYOR = Translations.makeKey("tips", "signal_block_surveyor");
        public static final String LINKS_CONTROLLERS_TO_RECEIVERS = Translations.makeKey("tips", "links_controllers_to_receivers");
        public static final String FUELED_BOILER_FIREBOX = Translations.makeKey("tips", "fueled_boiler_firebox");
        public static final String PRESSURE_BOILER_TANK = Translations.makeKey("tips", "pressure_boiler_tank");
        public static final String PRESSURE_BOILER_TANK_PRODUCTION = Translations.makeKey("tips", "pressure_boiler_tank.production");
        public static final String DIMENSIONS = Translations.makeKey("tips", "dimensions");
        public static final String APPLY_REDSTONE_TO_ENABLE = Translations.makeKey("tips", "apply_redstone_to_enable");
        public static final String APPLY_REDSTONE_TO_DISABLE = Translations.makeKey("tips", "apply_redstone_to_disable");
        public static final String APPLY_REDSTONE_TO_CHANGE_DIRECTION = Translations.makeKey("tips", "apply_redstone_to_change_direction");
        public static final String APPLY_REDSTONE_TO_OPEN = Translations.makeKey("tips", "apply_redstone_to_open");
        public static final String APPLY_REDSTONE_TO_RELEASE_CARTS = Translations.makeKey("tips", "apply_redstone_to_release_carts");
        public static final String APPLY_REDSTONE_TO_DISPENSE_CARTS = Translations.makeKey("tips", "apply_redstone_to_dispense_carts");
        public static final String APPLY_REDSTONE_TO_DISPENSE_TRAINS = Translations.makeKey("tips", "apply_redstone_to_release_trains");
        public static final String COMPARATOR_OUTPUT_FROM_CARTS = Translations.makeKey("tips", "comparator_output_from_carts");
        public static final String HIT_CROWBAR_TO_CHANGE_DIRECTION = Translations.makeKey("tips", "hit_crowbar_to_change_direction");
        public static final String HIT_CROWBAR_TO_CHANGE_DETECTION_DIRECTION = Translations.makeKey("tips", "hit_crowbar_to_change_detection_direction");
        public static final String HIT_CROWBAR_TO_CHANGE_RANGE = Translations.makeKey("tips", "hit_crowbar_to_change_range");
        public static final String HIT_CROWBAR_TO_CHANGE_MODE = Translations.makeKey("tips", "hit_crowbar_to_change_mode");
        public static final String HIT_CROWBAR_TO_CHANGE_FORCE = Translations.makeKey("tips", "hit_crowbar_to_change_force");
        public static final String HIT_CROWBAR_TO_CHANGE_TICKET = Translations.makeKey("tips", "hit_crowbar_to_change_ticket");
        public static final String HIT_CROWBAR_TO_ROTATE = Translations.makeKey("tips", "hit_crowbar_to_rotate");
        public static final String PAIR_WITH_CONTROL_TRACK = Translations.makeKey("tips", "pair_with_control_track");
        public static final String PLACE_OVER_TRACK = Translations.makeKey("tips", "place_over_track");
        public static final String PLACE_UNDER_TRACK = Translations.makeKey("tips", "place_under_track");
        public static final String PLACE_ABOVE_TRACK = Translations.makeKey("tips", "place_above_track");
        public static final String SLOW_UNPOWERED = Translations.makeKey("tips", "slow_unpowered");
        public static final String ACTIVATOR_TRACK = Translations.makeKey("tips", "activator_track");
        public static final String BOOSTER_TRACK = Translations.makeKey("tips", "booster_track");
        public static final String BUFFER_STOP_TRACK = Translations.makeKey("tips", "buffer_stop_track");
        public static final String CONTROL_TRACK = Translations.makeKey("tips", "control_track");
        public static final String DETECTOR_TRACK = Translations.makeKey("tips", "detector_track");
        public static final String DISEMBARKING_TRACK = Translations.makeKey("tips", "disembarking_track");
        public static final String EMBARKING_TRACK = Translations.makeKey("tips", "embarking_track");
        public static final String GATED_TRACK = Translations.makeKey("tips", "gated_track");
        public static final String COUPLER_TRACK = Translations.makeKey("tips", "coupler_track");
        public static final String LAUNCHER_TRACK = Translations.makeKey("tips", "launcher_track");
        public static final String ONE_WAY_TRACK = Translations.makeKey("tips", "one_way_track");
        public static final String WHISTLE_TRACK = Translations.makeKey("tips", "whistle_track");
        public static final String LOCOMOTIVE_TRACK = Translations.makeKey("tips", "locomotive_track");
        public static final String THROTTLE_TRACK = Translations.makeKey("tips", "throttle_track");
        public static final String LOCKING_TRACK = Translations.makeKey("tips", "locking_track");
        public static final String TRANSITION_TRACK = Translations.makeKey("tips", "transition_track");
        public static final String ROUTING_TRACK = Translations.makeKey("tips", "routing_track");
        public static final String SWITCH_TRACKS = Translations.makeKey("tips", "switch_track_lever");
        public static final String DUMPING_TRACK = Translations.makeKey("tips", "dumping_track");
        public static final String MANUAL_OPERATION = Translations.makeKey("tips", "manual_operation");
        public static final String SCRIPTED_LOGIC_OPERATION = Translations.makeKey("tips", "scripted_logic_operation");
        public static final String RELEVANT_TOOLS = Translations.makeKey("tips", "relevant_tools");
        public static final String SIGNAL_TUNER = Translations.makeKey("tips", "signal_tuner");
        public static final String AERIAL_LINKAGES = Translations.makeKey("tips", "aerial_linkages");
        public static final String RECEIVERS = Translations.makeKey("tips", "receivers");
        public static final String REDSTONE_LINKAGE = Translations.makeKey("tips", "redstone_linkage");
        public static final String LISTEN = Translations.makeKey("tips", "listen");
        public static final String CLICK_TO_CRAFT = Translations.makeKey("tips", "click_to_craft");
        public static final String ABANDONED_TRACK = Translations.makeKey("tips", "abandoned_track");
        public static final String REINFORCED_TRACK = Translations.makeKey("tips", "reinforced_track");
        public static final String STRAP_IRON_TRACK = Translations.makeKey("tips", "strap_iron_track");
        public static final String DANGER = Translations.makeKey("tips", "danger");
        public static final String DERAILMENT_RISK = Translations.makeKey("tips", "derailment_risk");
        public static final String HIGH_VOLTAGE = Translations.makeKey("tips", "high_voltage");
        public static final String HIGH_SPEED = Translations.makeKey("tips", "high_speed");
        public static final String HIGH_VOLTAGE_SPEED = Translations.makeKey("tips", "high_voltage_speed");
        public static final String POWERED_BY_ELECTRICITY = Translations.makeKey("tips", "powered_by_electricity");
        public static final String USE_ELECTRIC_LOCOMOTIVE = Translations.makeKey("tips", "use_electric_locomotive");
        public static final String VERY_FAST = Translations.makeKey("tips", "very_fast");
        public static final String REQUIRE_BOOSTERS_TRANSITION = Translations.makeKey("tips", "require_boosters_transition");
        public static final String CANNOT_MAKE_CORNERS_HIGH_SPEED = Translations.makeKey("tips", "cannot_make_corners_high_speed");
        public static final String EXPLOSION_RESISTANT = Translations.makeKey("tips", "explosion_resistant");
        public static final String CHARGE_NETWORK_BATTERY = Translations.makeKey("tips", "charge_network_battery");
        public static final String CHARGE_NETWORK_EMPTY_BATTERY = Translations.makeKey("tips", "charge_network_empty_battery");
        public static final String CAPACITY = Translations.makeKey("tips", "capacity");
        public static final String MAX_DRAW = Translations.makeKey("tips", "max_draw");
        public static final String LOSS = Translations.makeKey("tips", "loss");
        public static final String EFFICIENCY = Translations.makeKey("tips", "efficiency");
        public static final String TYPE_RECHARGEABLE = Translations.makeKey("tips", "type_rechargeable");
        public static final String TYPE_DISPOSABLE = Translations.makeKey("tips", "type_disposable");
    }

    public static class Screen {
        public static final String STEAM_TURBINE_ROTOR = Translations.makeKey("screen", "steam_turbine.rotor");
        public static final String STEAM_TURBINE_OUTPUT = Translations.makeKey("screen", "steam_turbine.output");
        public static final String STEAM_TURBINE_USAGE = Translations.makeKey("screen", "steam_turbine.usage");
        public static final String STEAM_MODE_DESC_IDLE = Translations.makeKey("screen", "locomotive.steam.mode.description.idle");
        public static final String STEAM_MODE_DESC_RUNNING = Translations.makeKey("screen", "locomotive.steam.mode.description.running");
        public static final String STEAM_MODE_DESC_SHUTDOWN = Translations.makeKey("screen", "locomotive.steam.mode.description.shutdown");
        public static final String ELECTRIC_MODE_DESC_RUNNING = Translations.makeKey("screen", "locomotive.electric.mode.description.running");
        public static final String ELECTRIC_MODE_DESC_SHUTDOWN = Translations.makeKey("screen", "locomotive.electric.mode.description.shutdown");
        public static final String CREATIVE_MODE_DESC_RUNNING = Translations.makeKey("screen", "locomotive.creative.mode.description.running");
        public static final String CREATIVE_MODE_DESC_SHUTDOWN = Translations.makeKey("screen", "locomotive.creative.mode.description.shutdown");
        public static final String LOCOMOTIVE_LOCK_LOCKED = Translations.makeKey("screen", "locomotive.lock.locked");
        public static final String LOCOMOTIVE_LOCK_UNLOCKED = Translations.makeKey("screen", "locomotive.lock.unlocked");
        public static final String LOCOMOTIVE_LOCK_PRIVATE = Translations.makeKey("screen", "locomotive.lock.private");
        public static final String LOCOMOTIVE_MODE_SHUTDOWN = Translations.makeKey("screen", "locomotive.mode.shutdown");
        public static final String LOCOMOTIVE_MODE_RUNNING = Translations.makeKey("screen", "locomotive.mode.running");
        public static final String LOCOMOTIVE_MODE_IDLE = Translations.makeKey("screen", "locomotive.mode.idle");
        public static final String SINGAL_CONTROLLER_BOX_DEFAULT = Translations.makeKey("screen", "signal_controller_box.default_aspect");
        public static final String SINGAL_CONTROLLER_BOX_POWERED = Translations.makeKey("screen", "signal_controller_box.powered_aspect");
        public static final String SIGNAL_CAPACITOR_BOX_DURATION = Translations.makeKey("screen", "signal_capacitor_box.duration");
        public static final String ACTION_SIGNAL_BOX_LOCKED = Translations.makeKey("screen", "action_signal_box.lock.locked");
        public static final String ACTION_SIGNAL_BOX_UNLOCKED = Translations.makeKey("screen", "action_signal_box.lock.unlocked");
        public static final String SWITCH_TRACK_MOTOR_REDSTONE = Translations.makeKey("screen", "switch_track_motor.redstone_triggered");
        public static final String CART_FILTERS = Translations.makeKey("screen", "manipulator.cart_filters");
        public static final String ITEM_MANIPULATOR_FILTERS = Translations.makeKey("screen", "item_manipulator.filters");
        public static final String ITEM_MANIPULATOR_BUFFER = Translations.makeKey("screen", "item_manipulator.buffer");
        public static final String TUNNEL_BORE_HEAD = Translations.makeKey("screen", "tunnel_bore.head");
        public static final String TUNNEL_BORE_FUEL = Translations.makeKey("screen", "tunnel_bore.fuel");
        public static final String TUNNEL_BORE_BALLAST = Translations.makeKey("screen", "tunnel_bore.ballast");
        public static final String TUNNEL_BORE_TRACK = Translations.makeKey("screen", "tunnel_bore.track");
        public static final String MULTIBLOCK_ASSEMBLY_FAILED = Translations.makeKey("screen", "multiblock.assembly_failed");
        public static final String EMBARKING_TRACK_RADIUS = Translations.makeKey("screen", "embarking_track.radius");
        public static final String LAUNCHER_TRACK_LAUNCH_FORCE = Translations.makeKey("screen", "launcher_track.launch_force");
        public static final String WATER_TANK_SEE_SKY = Translations.makeKey("screen", "water_tank.sky");
        public static final String WATER_TANK_BASE_RATE = Translations.makeKey("screen", "water_tank.base_rate");
        public static final String WATER_TANK_HUMIDITY = Translations.makeKey("screen", "water_tank.humidity");
        public static final String WATER_TANK_PRECIPITATION = Translations.makeKey("screen", "water_tank.precipitation");
        public static final String WATER_TANK_TEMP = Translations.makeKey("screen", "water_tank.temperature");
        public static final String WATER_TANK_FINAL_RATE = Translations.makeKey("screen", "water_tank.final_rate");
        public static final String PATTERN = Translations.makeKey("screen", "track_layer.patter");
        public static final String STOCK = Translations.makeKey("screen", "track_layer.stock");
        public static final String UNDER = Translations.makeKey("screen", "track_undercutter.under");
        public static final String SIDES = Translations.makeKey("screen", "track_undercutter.sides");
        public static final String HELP = Translations.makeKey("screen", "help");
        public static final String NAME = Translations.makeKey("screen", "name");
        public static final String GOLDEN_TICKET_TITLE = Translations.makeKey("screen", "golden_ticket.title");
        public static final String GOLDEN_TICKET_DESC_1 = Translations.makeKey("screen", "golden_ticket.desc1");
        public static final String GOLDEN_TICKET_DESC_2 = Translations.makeKey("screen", "golden_ticket.desc2");
        public static final String GOLDEN_TICKET_ABOUT = Translations.makeKey("screen", "golden_ticket.about");
        public static final String GOLDEN_TICKET_HELP = Translations.makeKey("screen", "golden_ticket.help");
        public static final String ROUTING_TABLE_BOOK = Translations.makeKey("screen", "routing_table_book");
        public static final String SWITCH_TRACK_ROUTER_PUBLIC_RAILWAY = Translations.makeKey("screen", "switch_track_router.public_railway");
        public static final String SWITCH_TRACK_ROUTER_PUBLIC_RAILWAY_DESC = Translations.makeKey("screen", "switch_track_router.public_railway.desc");
        public static final String SWITCH_TRACK_ROUTER_PRIVATE_RAILWAY = Translations.makeKey("screen", "switch_track_router.private_railway");
        public static final String SWITCH_TRACK_ROUTER_PRIVATE_RAILWAY_DESC = Translations.makeKey("screen", "switch_track_router.private_railway.desc");
    }

    public static class Tab {
        public static final String RAILCRAFT = "itemGroup.railcraft";
        public static final String RAILCRAFT_OUTFITTED_TRACKS = "itemGroup.railcraft_outfitted_tracks";
        public static final String RAILCRAFT_DECORATIVE_BLOCKS = "itemGroup.railcraft_decorative_blocks";
    }
}

