/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.material;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.block.CreosoteLiquidBlock;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.material.RailcraftFluidTypes;
import mods.railcraft.world.level.material.RailcraftFluids;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public abstract class CreosoteFluid
extends FlowingFluid {
    public Fluid m_5615_() {
        return (Fluid)RailcraftFluids.FLOWING_CREOSOTE.get();
    }

    public Fluid m_5613_() {
        return (Fluid)RailcraftFluids.CREOSOTE.get();
    }

    public Item m_6859_() {
        return (Item)RailcraftItems.CREOSOTE_BUCKET.get();
    }

    protected int m_6719_(LevelReader levelReader) {
        return 4;
    }

    protected BlockState m_5804_(FluidState fluidState) {
        return (BlockState)((CreosoteLiquidBlock)((Object)RailcraftBlocks.CREOSOTE.get())).m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(CreosoteFluid.m_76092_((FluidState)fluidState)));
    }

    public boolean m_6212_(Fluid fluid) {
        return fluid == RailcraftFluids.FLOWING_CREOSOTE.get() || fluid == RailcraftFluids.CREOSOTE.get();
    }

    protected int m_6713_(LevelReader levelReader) {
        return 1;
    }

    public int m_6718_(LevelReader levelReader) {
        return 5;
    }

    public boolean m_5486_(FluidState fluidState, BlockGetter blockGetter, BlockPos blockPos, Fluid fluid, Direction direction) {
        return direction == Direction.DOWN && !this.m_6212_(fluid);
    }

    protected float m_6752_() {
        return 50.0f;
    }

    public Vec3 m_7000_(BlockGetter blockGetter, BlockPos blockPos, FluidState fluidState) {
        return Vec3.f_82478_;
    }

    public FluidType getFluidType() {
        return (FluidType)RailcraftFluidTypes.CREOSOTE.get();
    }

    public static FluidType createFluidType() {
        FluidType.Properties properties = FluidType.Properties.create().density(1100).viscosity(3000);
        return new FluidType(properties){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){
                    private static final ResourceLocation STILL_TEXTURE = new ResourceLocation("block/water_still");
                    private static final ResourceLocation FLOW_TEXURE = new ResourceLocation("block/water_flow");

                    public int getTintColor() {
                        return -9805312;
                    }

                    public ResourceLocation getStillTexture() {
                        return STILL_TEXTURE;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return FLOW_TEXURE;
                    }

                    @NotNull
                    public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                        float x = (float)Integer.parseInt("6A", 16) / 255.0f;
                        float y = (float)Integer.parseInt("62", 16) / 255.0f;
                        float z = (float)Integer.parseInt("00", 16) / 255.0f;
                        return new Vector3f(x, y, z);
                    }

                    public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                        RenderSystem.setShaderFogStart((float)0.0f);
                        RenderSystem.setShaderFogEnd((float)3.0f);
                    }
                });
            }
        };
    }

    public boolean canConvertToSource(FluidState state, Level level, BlockPos pos) {
        return false;
    }

    protected void m_7456_(LevelAccessor level, BlockPos blockPos, BlockState blockState) {
        BlockEntity blockEntity = blockState.m_155947_() ? level.m_7702_(blockPos) : null;
        Block.m_49892_((BlockState)blockState, (LevelAccessor)level, (BlockPos)blockPos, (BlockEntity)blockEntity);
    }

    public static class Source
    extends CreosoteFluid {
        public int m_7430_(FluidState fluidState) {
            return 8;
        }

        public boolean m_7444_(FluidState fluidState) {
            return true;
        }

        protected boolean m_6760_(Level level) {
            return true;
        }
    }

    public static class Flowing
    extends CreosoteFluid {
        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> fluidState) {
            super.m_7180_(fluidState);
            fluidState.m_61104_(new Property[]{f_75948_});
        }

        public int m_7430_(FluidState fluidState) {
            return (Integer)fluidState.m_61143_((Property)f_75948_);
        }

        public boolean m_7444_(FluidState fluidState) {
            return false;
        }

        protected boolean m_6760_(Level level) {
            return false;
        }
    }
}

