/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.function.Supplier;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.track.SwitchTrackBlockEntity;
import mods.railcraft.world.level.block.entity.track.TurnoutTrackBlockEntity;
import mods.railcraft.world.level.block.track.outfitted.SwitchTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.jetbrains.annotations.Nullable;

public class TurnoutTrackBlock
extends SwitchTrackBlock
implements EntityBlock {
    public static final BooleanProperty MIRRORED = BooleanProperty.m_61465_((String)"mirrored");

    public TurnoutTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)super.buildDefaultState(blockState).m_61124_((Property)MIRRORED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{MIRRORED});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = super.m_5573_(context);
        BlockPos blockPos = context.m_8083_();
        return (BlockState)blockState.m_61124_((Property)MIRRORED, (Comparable)Boolean.valueOf(this.determineMirrored(context.m_43725_(), blockPos, TurnoutTrackBlock.getFacing(blockState))));
    }

    private boolean determineMirrored(Level level, BlockPos blockPos, Direction facing) {
        return level.m_8055_(blockPos.m_121945_(facing.m_122428_())).m_204336_(BlockTags.f_13034_);
    }

    @Override
    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldBlockState, boolean moved) {
        this.adjustShape(state, level, pos);
        super.m_6807_(state, level, pos, oldBlockState, moved);
    }

    protected void adjustShape(BlockState blockState, Level level, BlockPos pos) {
        BlockPos north = pos.m_122012_();
        BlockPos south = pos.m_122019_();
        BlockPos east = pos.m_122029_();
        BlockPos west = pos.m_122024_();
        if (BaseRailBlock.m_49364_((Level)level, (BlockPos)north) && BaseRailBlock.m_49364_((Level)level, (BlockPos)south) && BaseRailBlock.m_49364_((Level)level, (BlockPos)east) && BaseRailBlock.m_49364_((Level)level, (BlockPos)west)) {
            return;
        }
        switch (TrackUtil.getRailShapeRaw(blockState)) {
            case EAST_WEST: {
                if (!BaseRailBlock.m_49364_((Level)level, (BlockPos)north) || !BaseRailBlock.m_49364_((Level)level, (BlockPos)south)) {
                    return;
                }
                RailShape northShape = TrackUtil.getTrackDirection((BlockGetter)level, north);
                RailShape southShape = TrackUtil.getTrackDirection((BlockGetter)level, south);
                if (!northShape.equals((Object)RailShape.NORTH_SOUTH) || !southShape.equals((Object)RailShape.NORTH_SOUTH)) break;
                TrackUtil.setRailShape(level, pos, RailShape.NORTH_SOUTH);
                break;
            }
            case NORTH_SOUTH: {
                if (!BaseRailBlock.m_49364_((Level)level, (BlockPos)east) || !BaseRailBlock.m_49364_((Level)level, (BlockPos)west)) {
                    return;
                }
                RailShape eastShape = TrackUtil.getTrackDirection((BlockGetter)level, east);
                RailShape westShape = TrackUtil.getTrackDirection((BlockGetter)level, west);
                if (!eastShape.equals((Object)RailShape.EAST_WEST) || !westShape.equals((Object)RailShape.EAST_WEST)) break;
                TrackUtil.setRailShape(level, pos, RailShape.EAST_WEST);
                break;
            }
        }
    }

    @Override
    public void m_6861_(BlockState blockState, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean moved) {
        level.m_46597_(pos, (BlockState)blockState.m_61124_((Property)MIRRORED, (Comparable)Boolean.valueOf(this.determineMirrored(level, pos, TurnoutTrackBlock.getFacing(blockState)))));
        super.m_6861_(blockState, level, pos, neighborBlock, neighborPos, moved);
    }

    @Override
    protected boolean crowbarWhack(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack itemStack) {
        level.m_46597_(pos, (BlockState)((BlockState)blockState.m_61122_((Property)REVERSED)).m_61122_((Property)MIRRORED));
        return true;
    }

    @Override
    public RailShape getRailDirection(BlockState blockState, BlockGetter world, BlockPos pos, @Nullable AbstractMinecart cart) {
        boolean mirrored = TurnoutTrackBlock.isMirrored(blockState);
        if (TurnoutTrackBlock.isSwitched(blockState)) {
            return switch (TurnoutTrackBlock.getFacing(blockState)) {
                case Direction.NORTH -> {
                    if (mirrored) {
                        yield RailShape.SOUTH_WEST;
                    }
                    yield RailShape.SOUTH_EAST;
                }
                case Direction.SOUTH -> {
                    if (mirrored) {
                        yield RailShape.NORTH_EAST;
                    }
                    yield RailShape.NORTH_WEST;
                }
                case Direction.EAST -> {
                    if (mirrored) {
                        yield RailShape.NORTH_WEST;
                    }
                    yield RailShape.SOUTH_WEST;
                }
                case Direction.WEST -> {
                    if (mirrored) {
                        yield RailShape.SOUTH_EAST;
                    }
                    yield RailShape.NORTH_EAST;
                }
                default -> throw new IllegalStateException("Invalid facing direction.");
            };
        }
        return TurnoutTrackBlock.getRailShapeRaw(blockState);
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new TurnoutTrackBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.m_5776_() ? null : BaseEntityBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.TURNOUT_TRACK.get()), SwitchTrackBlockEntity::serverTick);
    }

    public static boolean isMirrored(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)MIRRORED);
    }
}

