/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.List;
import java.util.function.Supplier;
import mods.railcraft.Translations;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.track.CouplerTrackBlockEntity;
import mods.railcraft.world.level.block.track.outfitted.PoweredOutfittedTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class CouplerTrackBlock
extends PoweredOutfittedTrackBlock
implements EntityBlock {
    public static final EnumProperty<CouplerTrackBlockEntity.Mode> MODE = EnumProperty.m_61587_((String)"mode", CouplerTrackBlockEntity.Mode.class);

    public CouplerTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    protected BlockState buildDefaultState(BlockState blockState) {
        return (BlockState)super.buildDefaultState(blockState).m_61124_(MODE, (Comparable)((Object)CouplerTrackBlockEntity.Mode.COUPLER));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{MODE});
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new CouplerTrackBlockEntity(blockPos, blockState);
    }

    @Override
    protected boolean crowbarWhack(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, ItemStack itemStack) {
        CouplerTrackBlockEntity.Mode newCouplerMode;
        CouplerTrackBlockEntity.Mode couplerMode = CouplerTrackBlock.getMode(blockState);
        CouplerTrackBlockEntity.Mode mode = newCouplerMode = player.m_6047_() ? couplerMode.previous() : couplerMode.next();
        if (!level.m_5776_()) {
            level.m_46597_(blockPos, (BlockState)blockState.m_61124_(MODE, (Comparable)((Object)newCouplerMode)));
            MutableComponent currentMode = Component.m_237115_((String)Translations.Tips.CURRENT_MODE);
            MutableComponent mode2 = newCouplerMode.getDisplayName().m_6881_().m_130940_(ChatFormatting.DARK_PURPLE);
            player.m_5661_((Component)currentMode.m_130946_(" ").m_7220_((Component)mode2), true);
        }
        return true;
    }

    @Override
    public void onMinecartPass(BlockState blockState, Level level, BlockPos pos, AbstractMinecart cart) {
        super.onMinecartPass(blockState, level, pos, cart);
        level.m_141902_(pos, (BlockEntityType)RailcraftBlockEntityTypes.COUPLER_TRACK.get()).ifPresent(lockingTrack -> lockingTrack.minecartPassed(cart));
    }

    @Override
    public int getPowerPropagation(BlockState blockState, Level level, BlockPos pos) {
        return CouplerTrackBlock.getMode(blockState).getPowerPropagation();
    }

    public static CouplerTrackBlockEntity.Mode getMode(BlockState blockState) {
        return (CouplerTrackBlockEntity.Mode)((Object)blockState.m_61143_(MODE));
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.m_237115_((String)Translations.Tips.COUPLER_TRACK).m_130940_(ChatFormatting.GRAY));
        lines.add((Component)Component.m_237115_((String)Translations.Tips.HIT_CROWBAR_TO_CHANGE_MODE).m_130940_(ChatFormatting.BLUE));
        lines.add((Component)Component.m_237115_((String)Translations.Tips.APPLY_REDSTONE_TO_ENABLE).m_130940_(ChatFormatting.RED));
    }
}

