/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.signal;

import mods.railcraft.api.core.Lockable;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBoxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class SignalBoxBlock
extends CrossCollisionBlock {
    public static final BooleanProperty CAP = BooleanProperty.m_61465_((String)"cap");
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);

    public SignalBoxBlock(BlockBehaviour.Properties properties) {
        super(2.0f, 2.0f, 16.0f, 16.0f, 24.0f, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CAP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52309_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52310_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52311_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52312_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52313_, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean isConnected(BlockState state, Direction face) {
        BooleanProperty property = (BooleanProperty)f_52314_.get(face);
        return property != null && (Boolean)state.m_61143_((Property)property) != false;
    }

    public static boolean isAspectEmitter(BlockState blockState) {
        return blockState.m_204336_(RailcraftTags.Blocks.ASPECT_EMITTER);
    }

    public static boolean isAspectReceiver(BlockState blockState) {
        return blockState.m_204336_(RailcraftTags.Blocks.ASPECT_RECEIVER);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52309_, f_52310_, f_52312_, f_52311_, CAP, f_52313_});
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.m_83144_();
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean isMoving) {
        LevelUtil.getBlockEntity((BlockGetter)level, pos, AbstractSignalBoxBlockEntity.class).ifPresent(AbstractSignalBoxBlockEntity::neighborChanged);
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!blockState.m_60713_(newState.m_60734_())) {
            LevelUtil.getBlockEntity((BlockGetter)level, blockPos, AbstractSignalBoxBlockEntity.class).ifPresent(AbstractSignalBoxBlockEntity::blockRemoved);
        }
        super.m_6810_(blockState, level, blockPos, newState, isMoving);
    }

    public boolean m_7899_(BlockState blockState) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return LevelUtil.getBlockEntity(level, pos, AbstractSignalBoxBlockEntity.class).map(blockEntity -> blockEntity.getRedstoneSignal(direction)).orElse(0);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        FluidState fluidState = level.m_6425_(pos);
        return (BlockState)this.m_49966_().m_61124_((Property)f_52313_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState otherState, LevelAccessor level, BlockPos pos, BlockPos otherPos) {
        if (((Boolean)blockState.m_61143_((Property)f_52313_)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction.m_122434_().m_122479_() ? (BlockState)blockState.m_61124_((Property)f_52314_.get(direction), (Comparable)Boolean.valueOf(this.attachesTo(blockState, otherState))) : (direction == Direction.UP ? (BlockState)blockState.m_61124_((Property)CAP, (Comparable)Boolean.valueOf(!otherState.m_60795_())) : blockState);
    }

    public boolean attachesTo(BlockState blockState, BlockState otherBlockState) {
        if (!SignalBoxBlock.isAspectEmitter(blockState) && !SignalBoxBlock.isAspectReceiver(blockState)) {
            return false;
        }
        return SignalBoxBlock.isAspectReceiver(blockState) && SignalBoxBlock.isAspectEmitter(otherBlockState) || SignalBoxBlock.isAspectEmitter(blockState) && SignalBoxBlock.isAspectReceiver(otherBlockState);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter blockGetter, BlockPos pos) {
        return LevelUtil.getBlockEntity(blockGetter, pos, Lockable.class).filter(Lockable::isLocked).map(__ -> Float.valueOf(0.0f)).orElseGet(() -> Float.valueOf(super.m_5880_(state, player, blockGetter, pos))).floatValue();
    }
}

