/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import it.unimi.dsi.fastutil.chars.CharList;
import java.util.List;
import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.world.inventory.CokeOvenMenu;
import mods.railcraft.world.level.block.CokeOvenBricksBlock;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.multiblock.BlockPredicate;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockBlockEntity;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockPattern;
import mods.railcraft.world.module.CokeOvenModule;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class CokeOvenBlockEntity
extends MultiblockBlockEntity<CokeOvenBlockEntity, Void> {
    private static final MultiblockPattern<Void> PATTERN = (MultiblockPattern)Util.m_137537_(() -> {
        BlockPredicate bricks = BlockPredicate.of(RailcraftBlocks.COKE_OVEN_BRICKS);
        List<CharList> topAndBottom = List.of(CharList.of((char)'B', (char)'B', (char)'B'), CharList.of((char)'B', (char)'B', (char)'B'), CharList.of((char)'B', (char)'B', (char)'B'));
        return MultiblockPattern.builder(2, 1, 2).layer(topAndBottom).layer(List.of(CharList.of((char)'B', (char)'W', (char)'B'), CharList.of((char)'W', (char)'A', (char)'W'), CharList.of((char)'B', (char)'W', (char)'B'))).layer(topAndBottom).predicate('B', bricks).predicate('W', bricks).predicate('A', BlockPredicate.AIR).build();
    });
    private final CokeOvenModule cokeOvenModule;

    public CokeOvenBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.COKE_OVEN.get(), blockPos, blockState, CokeOvenBlockEntity.class, PATTERN);
        this.cokeOvenModule = this.moduleDispatcher.registerModule("coke_oven", new CokeOvenModule(this));
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, CokeOvenBlockEntity blockEntity) {
        blockEntity.serverTick();
        blockEntity.moduleDispatcher.serverTick();
        blockEntity.getMasterBlockEntity().ifPresent(master -> {
            boolean lit = master.cokeOvenModule.isProcessing();
            if (lit != (Boolean)blockState.m_61143_((Property)CokeOvenBricksBlock.LIT)) {
                level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)CokeOvenBricksBlock.LIT, (Comparable)Boolean.valueOf(lit)));
            }
        });
    }

    public CokeOvenModule getCokeOvenModule() {
        return this.cokeOvenModule;
    }

    @Override
    protected boolean isBlockEntity(MultiblockPattern.Element element) {
        return element.marker() == 'B' || element.marker() == 'W';
    }

    @Override
    protected void membershipChanged(@Nullable MultiblockBlockEntity.Membership<CokeOvenBlockEntity> membership) {
        if (membership == null) {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)((BlockState)this.m_58900_().m_61124_((Property)CokeOvenBricksBlock.WINDOW, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CokeOvenBricksBlock.LIT, (Comparable)Boolean.valueOf(false)));
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (Container)this.cokeOvenModule);
        } else {
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CokeOvenBricksBlock.WINDOW, (Comparable)Boolean.valueOf(membership.patternElement().marker() == 'W')));
        }
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new CokeOvenMenu(id, inventory, this);
    }

    @Override
    public Component m_5446_() {
        return Component.m_237115_((String)Translations.Container.COKE_OVEN);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        Optional<CokeOvenModule> masterModule = this.getMasterBlockEntity().map(CokeOvenBlockEntity::getCokeOvenModule);
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return masterModule.map(CokeOvenModule::getItemHandler).map(LazyOptional::cast).orElse(LazyOptional.empty());
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return masterModule.map(CokeOvenModule::getFluidHandler).map(LazyOptional::cast).orElse(LazyOptional.empty());
        }
        return super.getCapability(cap, side);
    }
}

