/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block;

import java.util.List;
import java.util.Map;
import mods.railcraft.Translations;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeBlock;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.world.level.block.MultiblockBlock;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.SteamTurbineBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class SteamTurbineBlock
extends MultiblockBlock
implements ChargeBlock {
    public static final Property<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);
    public static final Property<Boolean> ROTATED = BooleanProperty.m_61465_((String)"rotated");
    private static final Map<Charge, ChargeBlock.Spec> CHARGE_SPECS = ChargeBlock.Spec.make(Charge.distribution, ChargeBlock.ConnectType.BLOCK, 0.0f, new ChargeStorage.Spec(ChargeStorage.State.DISABLED, 225, 225, 1.0f));

    public SteamTurbineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TYPE, (Comparable)((Object)Type.NONE))).m_61124_(ROTATED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, ROTATED});
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new SteamTurbineBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.m_5776_() ? null : SteamTurbineBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.STEAM_TURBINE.get()), SteamTurbineBlockEntity::serverTick);
    }

    @Override
    public Map<Charge, ChargeBlock.Spec> getChargeSpecs(BlockState state, ServerLevel level, BlockPos pos) {
        return CHARGE_SPECS;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        Charge.zapEffectProvider().throwSparks(state, level, pos, rand, 50);
    }

    public void m_213897_(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource random) {
        super.m_213897_(blockState, level, blockPos, random);
        this.registerNode(blockState, level, blockPos);
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState oldState, boolean moved) {
        super.m_6807_(blockState, level, blockPos, oldState, moved);
        if (!blockState.m_60713_(oldState.m_60734_())) {
            this.registerNode(blockState, (ServerLevel)level, blockPos);
        }
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean moved) {
        super.m_6810_(blockState, level, blockPos, newState, moved);
        if (!blockState.m_60713_(newState.m_60734_())) {
            this.deregisterNode((ServerLevel)level, blockPos);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return Charge.distribution.network((ServerLevel)level).access(pos).getComparatorOutput();
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)Translations.Tips.MULTIBLOCK3X2X2).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)Translations.Tips.STEAM_TURBINE_DESC_1).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)Translations.Tips.STEAM_TURBINE_DESC_2).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)Translations.Tips.STEAM_TURBINE_DESC_3).m_130940_(ChatFormatting.GRAY));
    }

    public static enum Type implements StringRepresentable
    {
        TOP_LEFT("top_left"),
        TOP_RIGHT("top_right"),
        BOTTOM_LEFT("bottom_left"),
        BOTTOM_RIGHT("bottom_right"),
        WINDOW("window"),
        NONE("none");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

