/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.entity.FirestoneItemEntity;
import mods.railcraft.world.item.CrackedFirestoneItem;
import mods.railcraft.world.item.FirestoneItem;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefinedFirestoneItem
extends FirestoneItem {
    public static final int CHARGES = 5000;
    public static final int HEAT = 250;
    protected int heat = 250;
    protected final RandomSource random = RandomSource.m_216327_();

    public RefinedFirestoneItem(boolean spawnsFire, Item.Properties properties) {
        super(spawnsFire, properties);
    }

    public static ItemStack getItemCharged() {
        return ((RefinedFirestoneItem)((Object)RailcraftItems.REFINED_FIRESTONE.get())).m_7968_();
    }

    public static ItemStack getItemEmpty() {
        ItemStack itemStack = ((RefinedFirestoneItem)((Object)RailcraftItems.REFINED_FIRESTONE.get())).m_7968_();
        itemStack.m_41721_(4999);
        return itemStack;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        ItemStack newStack;
        double damageLevel = (double)itemStack.m_41773_() / (double)itemStack.m_41776_();
        if (this.random.m_188500_() < damageLevel * 1.0E-4) {
            newStack = CrackedFirestoneItem.getItemEmpty();
            if (itemStack.m_41788_()) {
                newStack.m_41714_(itemStack.m_41786_());
            }
        } else {
            newStack = itemStack.m_41777_();
        }
        newStack.m_41764_(1);
        return newStack.m_220157_(1, this.random, null) ? ItemStack.f_41583_ : newStack;
    }

    public final int getBurnTime(ItemStack itemStack, RecipeType<?> recipeType) {
        return itemStack.m_41773_() < itemStack.m_41776_() ? this.heat : 0;
    }

    @Override
    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> lines, TooltipFlag adv) {
        MutableComponent component = itemStack.m_41773_() >= itemStack.m_41776_() - 5 ? Component.m_237115_((String)Translations.Tips.FIRESTONE_EMPTY) : Component.m_237115_((String)Translations.Tips.FIRESTONE_CHARGED);
        lines.add((Component)component.m_130940_(ChatFormatting.GRAY));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        BlockState blockState = level.m_8055_(pos);
        RandomSource random = level.m_213780_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (stack.m_41773_() == stack.m_41776_()) {
            return InteractionResult.PASS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (player.m_36204_(pos, side, stack)) {
            BlockState newState;
            ItemStack cooked;
            List drops;
            if (blockState.m_60734_() != Blocks.f_50069_ && (drops = Block.m_49869_((BlockState)blockState, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)level.m_7702_(pos))).size() == 1 && !((ItemStack)drops.get(0)).m_41619_() && ((ItemStack)drops.get(0)).m_41720_() instanceof BlockItem && (cooked = this.cookedItem(level, (ItemStack)drops.get(0))).m_41720_() instanceof BlockItem && (newState = ContainerTools.getBlockStateFromStack(cooked, level, pos)) != null) {
                level.m_46597_(pos, newState);
                level.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.AMBIENT, 1.0f, random.m_188501_() * 0.4f + 0.8f);
                stack.m_220157_(1, random, serverPlayer);
                return InteractionResult.SUCCESS;
            }
            if (player.m_36204_(pos = pos.m_121945_(side), side, stack) && level.m_8055_(pos).m_60795_()) {
                level.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.AMBIENT, 1.0f, random.m_188501_() * 0.4f + 0.8f);
                level.m_46597_(pos, Blocks.f_50083_.m_49966_());
                stack.m_220157_(1, random, serverPlayer);
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    @NotNull
    private ItemStack cookedItem(Level level, ItemStack ingredient) {
        return level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{ingredient}), level).map(x -> x.m_8043_(level.m_9598_())).orElse(ItemStack.f_41583_);
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel && !livingEntity.m_5825_()) {
            livingEntity.m_20254_(5);
            itemStack.m_41622_(1, (LivingEntity)player, __ -> player.m_21190_(hand));
            level.m_5594_(null, livingEntity.m_20183_(), SoundEvents.f_11874_, SoundSource.AMBIENT, 1.0f, player.m_217043_().m_188501_() * 0.4f + 0.8f);
            player.m_6674_(hand);
            level.m_46597_(livingEntity.m_20183_(), Blocks.f_50083_.m_49966_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    @Override
    @NotNull
    public FirestoneItemEntity createEntity(Level level, Entity entity, ItemStack itemStack) {
        FirestoneItemEntity firestone = super.createEntity(level, entity, itemStack);
        firestone.setRefined(true);
        return firestone;
    }
}

