/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.inventory;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import mods.railcraft.gui.widget.Widget;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.SyncWidgetMessage;
import mods.railcraft.world.inventory.slot.RailcraftSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class RailcraftMenu
extends AbstractContainerMenu {
    private final Player player;
    private final Predicate<Player> validator;
    private final List<Widget> widgets = new ArrayList<Widget>();

    protected RailcraftMenu(@Nullable MenuType<?> type, int id, Player player, Predicate<Player> validator) {
        super(type, id);
        this.player = player;
        this.validator = validator;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean m_6875_(Player player) {
        return this.validator.test(player);
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    protected final void addInventorySlots(Inventory inventory) {
        this.addInventorySlots(inventory, 166);
    }

    protected final void addInventorySlots(Inventory inventory, int guiHeight) {
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.m_38897_(new Slot((Container)inventory, k + i * 9 + 9, 8 + k * 18, guiHeight - 82 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.m_38897_(new Slot((Container)inventory, j, 8 + j * 18, guiHeight - 24));
        }
    }

    public void addWidget(Widget widget) {
        this.widgets.add(widget);
        widget.added(this);
    }

    public final void m_38946_() {
        super.m_38946_();
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.widgets.forEach(widget -> this.sendWidgetPacket(serverPlayer, (Widget)widget));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendWidgetPacket(ServerPlayer player, Widget widget) {
        if (widget.requiresSync(player)) {
            FriendlyByteBuf byteBuf = new FriendlyByteBuf(Unpooled.buffer());
            try {
                widget.writeToBuf(player, byteBuf);
                SyncWidgetMessage message = new SyncWidgetMessage(this.f_38840_, widget.getId(), byteBuf);
                NetworkChannel.GAME.sendTo(message, player);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public void m_150399_(int slotId, int mouseButton, ClickType clickType, Player player) {
        RailcraftSlot railcraftSlot;
        if (slotId < 0) {
            return;
        }
        Slot slot = (Slot)this.f_38839_.get(slotId);
        if (slot instanceof RailcraftSlot && (railcraftSlot = (RailcraftSlot)slot).isPhantom()) {
            this.slotClickPhantom(railcraftSlot, mouseButton, clickType, player);
        }
        super.m_150399_(slotId, mouseButton, clickType, player);
    }

    protected void slotClickPhantom(RailcraftSlot slot, int mouseButton, ClickType clickType, Player player) {
        if (mouseButton == 2) {
            if (slot.canAdjustPhantom()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
        } else if (mouseButton == 0 || mouseButton == 1) {
            AbstractContainerMenu containerMenu = player.f_36096_;
            slot.m_6654_();
            ItemStack stackSlot = slot.m_7993_();
            ItemStack stackHeld = containerMenu.m_142621_();
            if (stackSlot.m_41619_() && !stackHeld.m_41619_() && slot.m_5857_(stackHeld)) {
                this.fillPhantomSlot(slot, stackHeld, mouseButton);
            } else if (stackHeld.m_41619_()) {
                this.adjustPhantomSlot(slot, mouseButton, clickType);
                slot.m_142406_(player, containerMenu.m_142621_());
            }
        }
    }

    protected void adjustPhantomSlot(RailcraftSlot slot, int mouseButton, ClickType clickType) {
        int stackSize;
        if (!slot.canAdjustPhantom()) {
            return;
        }
        ItemStack stackSlot = slot.m_7993_();
        if (stackSlot.m_41619_()) {
            return;
        }
        if (clickType == ClickType.QUICK_MOVE) {
            stackSize = mouseButton == 0 ? (stackSlot.m_41613_() + 1) / 2 : stackSlot.m_41613_() * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.m_41613_() - 1 : stackSlot.m_41613_() + 1;
        }
        if (stackSize > slot.m_6641_()) {
            stackSize = slot.m_6641_();
        }
        stackSlot.m_41764_(stackSize);
        if (stackSlot.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        }
    }

    protected void fillPhantomSlot(RailcraftSlot slot, ItemStack stackHeld, int mouseButton) {
        int stackSize;
        if (!slot.canAdjustPhantom()) {
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.m_41613_() : 1;
        if (stackSize > slot.m_6641_()) {
            stackSize = slot.m_6641_();
        }
        ItemStack phantomStack = stackHeld.m_41777_();
        phantomStack.m_41764_(stackSize);
        slot.m_5852_(phantomStack);
    }

    protected boolean shiftItemStack(ItemStack stackToShift, int start, int end) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.m_41753_()) {
            for (slotIndex = start; !stackToShift.m_41619_() && slotIndex < end; ++slotIndex) {
                int max;
                slot = (Slot)this.f_38839_.get(slotIndex);
                stackInSlot = slot.m_7993_();
                if (stackInSlot.m_41619_() || !ItemStack.m_41656_((ItemStack)stackInSlot, (ItemStack)stackToShift)) continue;
                int resultingStackSize = stackInSlot.m_41613_() + stackToShift.m_41613_();
                if (resultingStackSize <= (max = Math.min(stackToShift.m_41741_(), slot.m_6641_()))) {
                    stackToShift.m_41764_(0);
                    stackInSlot.m_41764_(resultingStackSize);
                    slot.m_6654_();
                    changed = true;
                    continue;
                }
                if (stackInSlot.m_41613_() >= max) continue;
                stackToShift.m_41774_(max - stackInSlot.m_41613_());
                stackInSlot.m_41764_(max);
                slot.m_6654_();
                changed = true;
            }
        }
        if (!stackToShift.m_41619_()) {
            for (slotIndex = start; !stackToShift.m_41619_() && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.f_38839_.get(slotIndex);
                stackInSlot = slot.m_7993_();
                if (!stackInSlot.m_41619_()) continue;
                int max = Math.min(stackToShift.m_41741_(), slot.m_6641_());
                stackInSlot = stackToShift.m_41777_();
                stackInSlot.m_41764_(Math.min(stackToShift.m_41613_(), max));
                stackToShift.m_41774_(stackInSlot.m_41613_());
                slot.m_5852_(stackInSlot);
                slot.m_6654_();
                changed = true;
            }
        }
        return changed;
    }

    protected boolean tryShiftItem(ItemStack stackToShift, int numSlots) {
        for (int machineIndex = 0; machineIndex < numSlots - 36; ++machineIndex) {
            RailcraftSlot slotRailcraft;
            Slot slot = (Slot)this.f_38839_.get(machineIndex);
            if (slot instanceof RailcraftSlot && ((slotRailcraft = (RailcraftSlot)slot).isPhantom() || !slotRailcraft.canShift()) || !slot.m_5857_(stackToShift) || !this.shiftItemStack(stackToShift, machineIndex, machineIndex + 1)) continue;
            return true;
        }
        return false;
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack originalStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        int numSlots = this.f_38839_.size();
        if (slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            assert (!stackInSlot.m_41619_());
            originalStack = stackInSlot.m_41777_();
            if ((slotIndex < numSlots - 36 || !this.tryShiftItem(stackInSlot, numSlots)) && (slotIndex >= numSlots - 36 && slotIndex < numSlots - 9 ? !this.shiftItemStack(stackInSlot, numSlots - 9, numSlots) : (slotIndex >= numSlots - 9 ? !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots - 9) : !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots)))) {
                return ItemStack.f_41583_;
            }
            slot.m_40234_(stackInSlot, originalStack);
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stackInSlot.m_41613_() == originalStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stackInSlot);
        }
        return originalStack;
    }
}

