/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle.locomotive;

import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.locomotive.BaseSteamLocomotive;
import mods.railcraft.world.inventory.SteamLocomotiveMenu;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.TicketItem;
import mods.railcraft.world.level.material.FluidItemHelper;
import mods.railcraft.world.level.material.steam.SolidFuelProvider;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SteamLocomotive
extends BaseSteamLocomotive
implements WorldlyContainer {
    private static final int FUEL_SLOT = 3;
    private static final int EXTRA_FUEL_SLOT_A = 4;
    private static final int EXTRA_FUEL_SLOT_B = 5;
    private static final int EXTRA_FUEL_SLOT_C = 6;
    private static final int TICKET_SLOT = 7;
    private static final int[] SLOTS = ContainerTools.buildSlotArray(0, 7);
    private final ContainerMapper fuelContainer = ContainerMapper.make((Container)this, 3, 1);
    private final ContainerMapper extraFuelContainer = ContainerMapper.make((Container)this, 4, 3);
    private final ContainerMapper allFuelContainer = ContainerMapper.make((Container)this, 3, 4);
    private final ContainerMapper ticketContainer = new ContainerMapper((Container)this, 7, 2).ignoreItemChecks();

    public SteamLocomotive(EntityType<?> type, Level level) {
        super(type, level);
        this.boiler().setFuelProvider(new SolidFuelProvider((Container)this, 3){

            @Override
            public float consumeFuel() {
                return SteamLocomotive.this.isShutdown() ? 0.0f : super.consumeFuel();
            }
        });
    }

    public SteamLocomotive(ItemStack itemStack, double x, double y, double z, ServerLevel serverLevel) {
        super(itemStack, (EntityType)RailcraftEntityTypes.STEAM_LOCOMOTIVE.get(), x, y, z, serverLevel);
        this.boiler().setFuelProvider(new SolidFuelProvider((Container)this, 3){

            @Override
            public float consumeFuel() {
                return SteamLocomotive.this.isShutdown() ? 0.0f : super.consumeFuel();
            }
        });
    }

    @Override
    protected DyeColor getDefaultPrimaryColor() {
        return DyeColor.LIGHT_GRAY;
    }

    @Override
    protected DyeColor getDefaultSecondaryColor() {
        return DyeColor.GRAY;
    }

    @Override
    public void m_8119_() {
        FluidStack pulledWater;
        super.m_8119_();
        if (this.m_9236_().m_5776_() || this.m_213877_()) {
            return;
        }
        this.extraFuelContainer.moveOneItemTo(this.fuelContainer);
        RollingStock rollingStock = RollingStock.getOrThrow((AbstractMinecart)this);
        ItemStack pulledFuel = rollingStock.pullItem(this.extraFuelContainer::canFit);
        if (!pulledFuel.m_41619_()) {
            this.extraFuelContainer.insert(pulledFuel);
        }
        if (this.isSafeToFill() && this.waterTank.getFluidAmount() < this.waterTank.getCapacity() / 2 && (pulledWater = rollingStock.pullFluid(new FluidStack((Fluid)Fluids.f_76193_, 1))) != null) {
            this.waterTank.fill(pulledWater, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public boolean needsFuel() {
        FluidStack water = this.waterTank.getFluid();
        if (water.isEmpty() || water.getAmount() < this.waterTank.getCapacity() / 3) {
            return true;
        }
        int numItems = this.allFuelContainer.countItems(item -> ForgeHooks.getBurnTime((ItemStack)item, null) > 0);
        if (numItems == 0) {
            return true;
        }
        int maxItems = this.allFuelContainer.countMaxItemStackSize();
        return (float)numItems / (float)maxItems < 0.25f;
    }

    @Override
    protected Container ticketContainer() {
        return this.ticketContainer;
    }

    @Override
    public int m_6643_() {
        return 9;
    }

    public int[] m_7071_(Direction side) {
        return SLOTS;
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction side) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction side) {
        return slot < 7;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return switch (slot) {
            case 3, 4, 5, 6 -> {
                if (ForgeHooks.getBurnTime((ItemStack)stack, null) > 0) {
                    yield true;
                }
                yield false;
            }
            case 0 -> FluidItemHelper.containsFluid(stack, (Fluid)Fluids.f_76193_);
            case 7 -> TicketItem.FILTER.test(stack);
            default -> false;
        };
    }

    @Override
    public boolean canAcceptPushedItem(RollingStock requester, ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
    }

    @Override
    public boolean canProvidePulledItem(RollingStock requester, ItemStack stack) {
        return false;
    }

    protected AbstractContainerMenu m_7402_(int id, Inventory playerInventory) {
        return new SteamLocomotiveMenu(id, playerInventory, this);
    }

    public Item m_213728_() {
        return (Item)RailcraftItems.STEAM_LOCOMOTIVE.get();
    }
}

