/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import java.util.HashSet;
import java.util.Set;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.MaintenanceMinecart;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.TrackRemoverCartItem;
import mods.railcraft.world.level.block.RailcraftBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TrackRemover
extends MaintenanceMinecart {
    private final Set<BlockPos> tracksBehind = new HashSet<BlockPos>();
    private final Set<BlockPos> tracksRemoved = new HashSet<BlockPos>();

    public TrackRemover(EntityType<?> type, Level level) {
        super(type, level);
    }

    public TrackRemover(ItemStack itemStack, double x, double y, double z, ServerLevel level) {
        super((EntityType)RailcraftEntityTypes.TRACK_REMOVER.get(), x, y, z, (Level)level);
    }

    protected void m_6401_(BlockPos pos, BlockState state) {
        super.m_6401_(pos, state);
        if (this.m_9236_().m_5776_()) {
            return;
        }
        for (BlockPos track : this.tracksBehind) {
            if (track.equals((Object)pos)) continue;
            this.removeTrack(track);
        }
        this.tracksBehind.removeAll(this.tracksRemoved);
        this.tracksRemoved.clear();
        this.addTravelledTrack(pos);
    }

    private void addTravelledTrack(BlockPos pos) {
        this.tracksBehind.add(pos);
    }

    private void removeTrack(BlockPos track) {
        if (this.mode() == MaintenanceMinecart.Mode.OFF) {
            return;
        }
        if (track.m_123331_((Vec3i)this.m_20183_()) >= 9.0) {
            this.tracksRemoved.add(track);
        } else if (!BaseRailBlock.m_49364_((Level)this.m_9236_(), (BlockPos)track)) {
            this.tracksRemoved.add(track);
        } else if (this.m_9236_().m_8055_(track).m_60713_((Block)RailcraftBlocks.FORCE_TRACK.get())) {
            this.tracksRemoved.add(track);
        } else if (EntitySearcher.findMinecarts().at(track).inflate(0.2f).list(this.m_9236_()).isEmpty()) {
            this.removeOldTrack(track, this.m_9236_().m_8055_(track));
            this.blink();
            this.tracksRemoved.add(track);
        }
    }

    @Override
    protected boolean hasMenu() {
        return false;
    }

    protected AbstractContainerMenu m_7402_(int id, Inventory inventory) {
        return null;
    }

    public ItemStack m_142340_() {
        return ((TrackRemoverCartItem)((Object)RailcraftItems.TRACK_REMOVER.get())).m_7968_();
    }

    public Item m_213728_() {
        return (Item)RailcraftItems.TRACK_REMOVER.get();
    }
}

