/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import java.util.EnumSet;
import java.util.Set;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.MaintenanceMinecart;
import mods.railcraft.world.entity.vehicle.MaintenancePatternMinecart;
import mods.railcraft.world.inventory.TrackRelayerMenu;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.TrackRelayerCartItem;
import mods.railcraft.world.level.block.entity.track.DumpingTrackBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;

public class TrackRelayer
extends MaintenancePatternMinecart {
    private static final int STOCK_SLOT = 0;
    private static final int REPLACE_SLOT = 1;
    private static final int[] SLOTS = ContainerTools.buildSlotArray(0, 1);
    private static final int EXISTING_TRACK_SLOT = 0;
    private static final Set<Direction> HORIZONTAL_DIRECTION = EnumSet.of(Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH);

    public TrackRelayer(EntityType<?> type, Level level) {
        super(type, level);
    }

    public TrackRelayer(ItemStack itemStack, double x, double y, double z, ServerLevel level) {
        super((EntityType)RailcraftEntityTypes.TRACK_RELAYER.get(), x, y, z, (Level)level);
    }

    public ItemStack m_142340_() {
        return ((TrackRelayerCartItem)((Object)RailcraftItems.TRACK_RELAYER.get())).m_7968_();
    }

    public Item m_213728_() {
        return (Item)RailcraftItems.TRACK_RELAYER.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.mode() == MaintenanceMinecart.Mode.OFF) {
            return;
        }
        this.stockItems(1, 0);
        this.replace();
    }

    private void replace() {
        BlockState blockState;
        BlockPos pos = this.m_20183_();
        if (BaseRailBlock.m_49364_((Level)this.m_9236_(), (BlockPos)pos.m_7495_())) {
            pos = pos.m_7495_();
        }
        if (!BaseRailBlock.m_49416_((BlockState)(blockState = this.m_9236_().m_8055_(pos)))) {
            return;
        }
        Block block = blockState.m_60734_();
        ItemStack existingTrack = this.patternContainer.m_8020_(0);
        if (existingTrack.m_41619_()) {
            return;
        }
        ItemStack stockTrack = this.m_8020_(0);
        if (stockTrack.m_41619_()) {
            return;
        }
        boolean nextToSuspended = false;
        for (Direction direction : HORIZONTAL_DIRECTION) {
            BlockEntity blockEntity = this.m_9236_().m_7702_(pos.m_121955_(direction.m_122436_()));
            if (!(blockEntity instanceof DumpingTrackBlockEntity)) continue;
            nextToSuspended = true;
            break;
        }
        if (nextToSuspended) {
            return;
        }
        if (ContainerTools.isItemStackBlock(existingTrack, block)) {
            RailShape trackShape = this.removeOldTrack(pos, blockState);
            this.placeNewTrack(pos, 0, trackShape);
        }
    }

    public int[] m_7071_(Direction side) {
        return SLOTS;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        ItemStack trackReplace = this.patternContainer.m_8020_(1);
        return ItemStack.m_41656_((ItemStack)stack, (ItemStack)trackReplace);
    }

    protected AbstractContainerMenu m_7402_(int id, Inventory inventory) {
        return new TrackRelayerMenu(id, inventory, this);
    }
}

